<?php
// Include necessary files, database models, and other required setups
include_once 'model/sales_model.php';  // Assuming you have a sales model
$sales_model = new sales_model();
$sales_range = $_GET['range'];
$daily_sales = $sales_model->getSales($sales_range); 
date_default_timezone_set('Africa/Blantyre');
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <!-- Meta, title, CSS, favicons, etc. -->
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="icon" href="images/favicon.png" type="image/ico" />
        <title>Powertex LTD - Manage Sales</title>
        <?php
            include_once 'css_links.php';
        ?>
    </head>

    <body class="nav-md">
        <div class="container body">
            <div class="main_container">

                <?php
                    include 'menu_finance.php';
                ?>

                <!-- page content -->
                <div class="right_col" role="main">
                    <div class="">
                        <div class="page-title">
                            <div class="title_left">
                                <h3><small>Sales </small></h3>
                            </div>
                        </div>
                        <div class="clearfix"></div>
                        <div class="row">
                            <div class="col-md-12 col-sm-12 ">
                                <div class="x_panel">
                                    <div class="x_title d-flex justify-content-between align-items-center" style="display: flex;">
                                        <!-- Left side: Title -->
                                        <div>
                                            <h2 class="mb-0">Sales Report</h2>
                                        </div>

                                        <!-- Center: Title -->
                                        <div class="text-center flex-grow-1">
                                            <h5 class="mb-0">Sales Overview</h5>
                                        </div>

                                        <!-- Right side: Back Button -->
                                        <ul class="nav navbar-right panel_toolbox mb-0">
                                            <li>
                                                <a class="dropdown-item" href="dashboard.php">
                                                    <button class="btn btn-secondary btn-sm">
                                                        <i class="fa fa-arrow-left"></i> Back
                                                    </button>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="clearfix"></div>

                                    

                                    <div class="x_content">
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="card-box table-responsive">                                                          
                                                    <?php if (!empty($daily_sales)) { ?>
                                                        <table class="table table-bordered table-sm">
                                                            <thead>
                                                                <tr>
                                                                    <th>Transaction Date</th>
                                                                    <th>Customer Name</th>
                                                                    <th>Transaction Type</th>
                                                                    <th>Payment Method</th>
                                                                    <th>Transaction ID</th>
                                                                    <th>Total Sales Amount</th>
                                                                    <th>Sale Status</th>
                                                                    <th>Action</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <?php foreach ($daily_sales as $sale) { ?>
                                                                    <tr>
                                                                        <td><?php echo date('d F,Y', strtotime($sale['sale_date'])); ?></td>
                                                                        <td><?php echo htmlspecialchars($sale['customer_name']); ?></td>
                                                                        <td><?php echo htmlspecialchars($sale['transaction_type']); ?></td>
                                                                        <td><?php echo htmlspecialchars($sale['payment_method']); ?></td>
                                                                        <td><?php echo htmlspecialchars($sale['transction_id']); ?></td>
                                                                        <td style="text-align: right;">
                                                                            <?php echo number_format($sale['total_sales_amount'], 2); ?>
                                                                        </td>
                                                                        <td class="<?php
                                                                            // Adding color-coding based on sale status
                                                                            $status = $sale['sale_status'];
                                                                            $type = $sale['transaction_type'];

                                                                            if($type == 'Cash Sale' && $status == 0){
                                                                                echo 'bg-danger text-white';
                                                                            }elseif($type == 'Cash Sale' && $status == 1){
                                                                                echo 'bg-success text-white';
                                                                            }elseif($type == 'Customer Invoice' && $status == 0){
                                                                                echo 'bg-secondary text-white';
                                                                            }elseif($type == 'Customer Invoice' && $status == 1){
                                                                                echo 'bg-warning text-black';
                                                                            }elseif($type == 'Customer Invoice' && $status == 2){
                                                                                echo 'bg-success text-white';
                                                                            }
                                                            
                                                                        ?>">
                                                                            <?php echo htmlspecialchars(ucfirst($sale['status'])); ?>
                                                                        </td>
                                                                        <td>
                                                                            <?php
                                                                                $order_type = $sale['transaction_type'];  // Assuming this is the field in your $sale array

                                                                                // Determine the appropriate URL based on the order_type
                                                                                if ($order_type == 'Cash Sale') {
                                                                                    $url = "cash_sale_receipt.php?id=" . $sale['sale_id'];
                                                                                } elseif ($order_type == 'Customer Invoice') {
                                                                                    $url = "invoice.php?invoice_number=" . $sale['sale_id'];
                                                                                } else {
                                                                                    
                                                                                }
                                                                            ?>

                                                                                <a href="<?php echo $url; ?>" class="btn btn-info btn-sm" title="Sales Receipt">
                                                                                    <i class="fa fa-receipt"></i>
                                                                                </a>
                                                                            <a href="javascript:void(0);" onclick="showDisabledNotification()">
                                                                                <button class="btn btn-info btn-sm">
                                                                                    <i class="fa fa-cog"></i>
                                                                                </button>
                                                                            </a>
                                                                        </td>
                                                                    </tr>
                                                                <?php } ?>
                                                            </tbody>
                                                        </table>
                                                    <?php } else { ?>
                                                        <div class="alert alert-info">
                                                            No sales data available for today.
                                                        </div>
                                                    <?php } ?>
                                                    
                                                  
                                                </div>
                                            </div>
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /page content -->

                <?php
                    include_once 'footer.php';
                ?>
            </div>
        </div>

        <?php
            include_once 'libraries.php';
        ?>
        <script>
            function showDisabledNotification() {
                const type = 'warning';
                const title = 'Feature Disabled';
                const message = 'This feature is currently disabled.';

                toastr[type](message, title);
            }
        </script>
    </body>
</html>
