<?php

session_start();
date_default_timezone_set('Africa/Blantyre'); // ✅ Set your default timezone

include_once 'model/employees_model.php';

$employees_model = new employees_model();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $departmentName = trim($_POST['name_department']);
    $operator = $_SESSION['sess_employeecode'];
    $datecaptured = date('Y-m-d H:i');

    if (!empty($departmentName)) {

        $count = $employees_model->checkDepartment($departmentName);

        if ($count > 0) {
            $_SESSION['notification'] = [
                'type' => 'error',
                'title' => 'FAILED',
                'message' => "Department already exists."
            ];
            header('location:manage_posts.php');
            exit();
        } else {
            $saved = $employees_model->saveDepartment($departmentName, $datecaptured, $operator);

            if ($saved) {
                $_SESSION['notification'] = [
                    'type' => 'info',
                    'title' => 'SUCCESS',
                    'message' => "Department Added Successfully."
                ];
                header('location:manage_posts.php');
                exit();
            } else {
                $_SESSION['notification'] = [
                    'type' => 'error',
                    'title' => 'FAILED',
                    'message' => "Failed to save department."
                ];
                header('location:manage_posts.php');
                exit();
            }
        }
    } else {
        $_SESSION['notification'] = [
            'type' => 'error',
            'title' => 'FAILED',
            'message' => "Department name is required."
        ];
        header('location:manage_posts.php');
        exit();
    }
}
?>
