<?php
include_once 'model/transfers_model.php';
$transfers_model = new transfers_model();

if (!isset($_GET['shipment_id']) || empty($_GET['shipment_id'])) {
    header('Location: manage_transfers.php');
    exit;
}

$id = (int) $_GET['shipment_id'];

$header = $transfers_model->headerDetails($id);
$items  = $transfers_model->getShipmentTransferItems($id);

if (!$header) {
    echo "<div class='alert alert-danger'>Shipment not found.</div>";
    exit;
}

$state = (int) ($header['transfer_state'] ?? 1);

switch ($state) {
    case 2:
        $status       = 'completed';
        $statusLabel  = 'Completed';
        $statusClass  = 'badge-success';
        break;

    case 0:
        $status       = 'cancelled';
        $statusLabel  = 'Cancelled';
        $statusClass  = 'badge-danger';
        break;

    case 1:
    default:
        $status       = 'pending';
        $statusLabel  = 'Pending Approval';
        $statusClass  = 'badge-warning';
        break;
}
        
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Powertex LTD - Transfer Details</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?php include_once 'css_links.php'; ?>

    <style>
        /* PAGE FEEL */
        .right_col {
            background: #f4f6f9;
        }

        /* DOCUMENT HEADER */
        .doc-header {
            background: #ffffff;
            border-radius: 8px;
            padding: 20px 25px;
            box-shadow: 0 3px 10px rgba(0,0,0,0.06);
            margin-bottom: 25px;
        }

        .doc-header h2 {
            font-weight: 600;
        }

        /* INFO CARDS */
        .info-card {
            background: #ffffff;
            border-radius: 8px;
            padding: 20px;
            box-shadow: 0 3px 10px rgba(0,0,0,0.06);
            border-left: 4px solid #2A3F54;
        }

        .info-card h4 {
            font-size: 16px;
            margin-bottom: 15px;
            font-weight: 600;
        }

        /* TABLE */
        table.table {
            background: #ffffff;
        }

        table th {
            background: #f1f3f5;
            font-size: 13px;
            text-transform: uppercase;
        }

        table td {
            font-size: 14px;
        }

            

        /* SUMMARY */
        .summary-box {
            background: #ffffff;
            padding: 20px;
            border-radius: 8px;
            border: 1px solid #e1e1e1;
            box-shadow: 0 3px 10px rgba(0,0,0,0.05);
        }

        .summary-box .total {
            font-size: 20px;
            font-weight: 600;
            color: #2A3F54;
        }

        /* STATUS */
        .status-badge {
            border-radius: 20px;
            padding: 6px 14px;
            font-weight: 500;
        }

        /* PRINT */
        @media print {
            .btn,
            .nav-md,
            footer,
            .x_title {
                display: none !important;
            }

            .right_col {
                background: #fff !important;
                margin: 0 !important;
                padding: 0 !important;
            }

            .info-card,
            .summary-box,
            .doc-header {
                box-shadow: none !important;
                border: 1px solid #000;
            }
        }
    </style>

</head>

<body class="nav-md">
<div class="container body">
<div class="main_container">

<?php include 'menu_finance.php'; ?>

<div class="right_col" role="main">

    <!-- DOCUMENT HEADER -->
    <div class="doc-header">
        <img src="images/logo.png" style="height: 60px;" alt="Company Logo">
        <div>
            <h2 class="mb-0">Stock Transfer Shipment</h2>
            <small class="text-muted">
                Ref: <?= htmlspecialchars($header['reference_no']) ?>
            </small>

            <span class="badge <?= $statusClass ?> status-badge">
                <?= $statusLabel ?>
            </span>
        </div>
    </div>

    <!-- ACTION BAR -->
    <div class="x_panel">
        <div class="x_title d-flex justify-content-between align-items-center">
            <h3>
                <i class="fa fa-truck text-primary"></i> Transfer Details
            </h3>

            <div class="btn-group">
                
                <button onclick="history.back()" class="btn btn-secondary btn-sm">
                    <i class="fa fa-arrow-left"></i> Back
                </button>
            </div>
        </div>

        <div class="x_content">

            <!-- INFO SECTION -->
            <div class="row">
                <div class="col-md-6">
                    <div class="info-card">
                        <h4><i class="fa fa-info-circle text-info"></i> Shipment Information</h4>
                        <hr>
                        <p><strong>Date:</strong> <?= date('d F Y', strtotime($header['shipment_date'])) ?></p>
                        <p><strong>Reference:</strong> <?= htmlspecialchars($header['reference_no']) ?></p>
                        <p><strong>Waybill:</strong> <?= htmlspecialchars($header['waybill_no']) ?: '-' ?></p>
                        <p><strong>Transport:</strong> <?= htmlspecialchars($header['transport_mode']) ?></p>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="info-card">
                        <h4><i class="fa fa-users text-success"></i> Parties</h4>
                        <hr>
                        <p><strong>Supplier:</strong> <?= htmlspecialchars($header['supplier_name']) ?></p>
                        <p><strong>Receiving Company:</strong> <?= htmlspecialchars($header['receiver_name']) ?></p>
                        <p><strong>Processed By:</strong> <?= htmlspecialchars($header['operator_name']) ?></p>
                    </div>
                </div>
            </div>

            <!-- ITEMS TABLE -->
            <h4>
                <i class="fa fa-list-alt text-primary"></i> Shipment Items
            </h4>

            <table class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Item</th>
                        <th class="text-right">Opening</th>
                        <th class="text-right">Qty</th>
                        <th class="text-right">Closing</th>
                        <?php
                        if($procurement_mode == 1){ ?>
                        <th class="text-right">Unit Cost</th>
                        <th class="text-right">Total</th>
                        <?php } ?>
                    </tr>
                </thead>
                <tbody>
                <?php
                $i = 1;
                $grandTotal = 0;
                foreach ($items as $row):
                    $grandTotal += $row['total_cost'];
                ?>
                    <tr>
                        <td><?= $i++ ?></td>
                        <td><?= htmlspecialchars($row['product_name']) ?></td>
                        <td class="text-right"><?= number_format($row['opening_balance']) ?></td>
                        <td class="text-right"><?= number_format($row['quantity']) ?></td>
                        <td class="text-right"><?= number_format($row['closing_stock']) ?></td>
                        <?php if($procurement_mode == 1){ ?>
                        <td class="text-right"><?= number_format($row['order_price'], 2) ?></td>
                        <td class="text-right"><?= number_format($row['total_cost'], 2) ?></td>
                        <?php } ?>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>

            <!-- TOTALS -->
             <?php
                if($procurement_mode == 1){ ?>
            <div class="row">
                <div class="col-md-6"></div>
                <div class="col-md-6">
                    <div class="summary-box">
                        <p>
                            <i class="fa fa-cubes"></i>
                            Total Items
                            <span class="pull-right"><?= count($items) ?></span>
                        </p>
                        <p class="total">
                            <i class="fa fa-money"></i>
                            Total Cost
                            <span class="pull-right"><?= number_format($grandTotal, 2) ?></span>
                        </p>
                    </div>
                </div>
            </div>
            <?php } ?>

        </div>
    </div>

</div>

<?php include_once 'footer.php'; ?>
</div>
</div>

<?php include_once 'libraries.php'; ?>
</body>
</html>
