<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>Third Party Companies</title>
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <?php include_once 'css_links.php'; ?>
    </head>
    <body class="nav-md">
        <div class="container body">
            <div class="main_container">
                <?php 
                    include 'menu_finance.php';
                    include_once 'model/companies_model.php';

                    $company_id = $_GET['company_id'] ?? null;

                    if (!$company_id) {
                        // fallback if no company ID is passed
                        die("No company selected.");
                    }

                    $companies_model = new companies_model();
                    $company = $companies_model->getThirdPartyCompanyDetails($company_id);
                    $products = $companies_model->getThirdPartyCompanyProducts($company_id);


                ?>

                <!-- page content -->
                <div class="right_col" role="main">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="x_panel">
                                <div class="x_title d-flex justify-content-between align-items-center">
                                    <h2>Products for <strong><?= htmlspecialchars($company['company_name']) ?></strong></h2>
                                    <div>
                                        <div class="d-flex align-items-center gap-2">
                                            <form name="third_party_products" action="generate_pdf.php" method="post" class="mb-0 me-2">
                                                <input name="third_company_products" value="third_company_products" type="hidden" readonly>
                                                <input type="hidden" name="company_id" value="<?php echo $company_id?>" readonly>
                                                <button type="submit" class="btn btn-danger btn-sm">
                                                    Generate PDF <i class="fa fa-file-pdf"></i> 
                                                </button>
                                            </form>

                                            <button class="btn btn-warning btn-sm" onclick="history.back();">
                                                <i class="fa fa-arrow-left"></i> Back
                                            </button>
                                        </div>


                                        
                                    </div>
                                </div>
                                <div class="x_content">
                                        <table class="table table-striped table-bordered">
                                            <thead class="bg-success text-white" style="text-align: center;">
                                                <th>#</th>
                                                <th>Product Name</th>
                                                <th>Category</th>
                                                <th>Opening Stock</th>
                                                <th>Total Received</th>
                                                <th>Total Released</th>
                                                <th>Pending Transfer In</th>
                                                <th>Pending Transfer Out</th>
                                                <th>Projected Quantity</th>
                                                <th>After Transfers</th>
                                                <th>Status</th>
                                                <th>Action</th>
                                            </thead>   
                                            <tbody>
                                                <?php foreach ($products as $i => $item): ?>
                                                    <?php

                                                        $projected_quantity = $item['quantity'] 
                                                                            + ($item['total_pending_in'] ?? 0);

                                                        $bg_class = $item['product_state'] == 1 ? 'bg-success text-white' : 'bg-danger text-white';
                                                    ?>
                                                    <tr>
                                                        <td><?= $i + 1 ?></td>
                                                        <td><?= $item['product_name'] ?></td>
                                                        <td><?= $item['category'] ?></td>
                                                        <td class="text-center"><?= number_format($item['opening_stock'], 0) ?></td>
                                                        <td class="text-center"><?= number_format($item['total_received'], 0) ?></td>
                                                        <td class="text-center"><?= number_format($item['total_released'], 0) ?></td>
                                                        <td class="text-center"><?= number_format($item['total_pending_in'], 0) ?></td>
                                                        <td class="text-center"><?= number_format($item['total_pending_out'], 0) ?></td>
                                                        <td class="text-center"><?= number_format($item['quantity'], 0) ?></td>
                                                        <td class="text-center font-weight-bold"><?= number_format($projected_quantity, 0) ?></td>
                                                        <td class="<?= $bg_class ?>"><?= $item['product_status'] ?></td>
                                                        <td>
                                                            <a href="breakdown_third_party_transfers.php?company_id=<?= $company_id?>&product_id=<?= $item['product_id']?>">
                                                                <button class="btn btn-sm btn-info">
                                                                    <i class="fa fa-list"></i>
                                                                </button>
                                                            </a>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>

                                            </tbody>             
                                        </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> 
                <!-- /page content -->
                <?php 
                    include_once 'footer.php'; 
                ?>
            </div>
        </div>

        <?php 
            include_once 'libraries.php'; 
        ?>
    </body>
</html>
