<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>Third Party Companies</title>
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <?php include_once 'css_links.php'; ?>
        <style>
            #categoryDistributionChart {
                height: 350px !important;
            }
        </style>
    </head>
    <body class="nav-md">
        <div class="container body">
            <div class="main_container">
                <?php 
                    include 'menu_finance.php';
                    
                    include_once 'model/company_model.php';
                    $company_id = $_GET['id'];
                    $companies_model = new company_model();
                    $companies = $companies_model->getThirdPartyCompanyDetails($company_id);

                    $category_data = $companies_model->getProductCountByCategory($company_id);

                    $categories = [];
                    $category_counts = [];
                    foreach ($category_data as $data) {
                        $categories[] = $data['category_name'];
                        $category_counts[] = $data['product_count'];
                    }


                ?>

                <!-- page content -->
                <div class="right_col" role="main">
                    <div class="">
                        <div class="row">
                            <div class="col-md-12 col-sm-12">
                                <div class="x_panel">
                                    <div class="x_title d-flex justify-content-between align-items-center">
                                        <div>
                                            <h2 class="mb-0">Third Party Companies</h2>
                                        </div>

                                        <div class="text-center flex-grow-1">
                                            <h5 class="mb-0">Company Details - <?php echo $companies['company_name']?></h5>
                                        </div>

                                        <!-- Right side: Back & Add New Button -->
                                        <ul class="nav navbar-right panel_toolbox mb-0">
                                            

                                            <li>
                                                <button class="btn btn-warning btn-sm" 
                                                        data-toggle="modal" 
                                                        data-target="#editCompanyModal" 
                                                        onclick="loadCompanyDetails('<?= $company_id ?>')">
                                                    <i class="fa fa-edit"></i> Edit
                                                </button>
                                            </li>
                                            <li>
                                                <button class="btn btn-secondary btn-sm" onclick="history.back();">
                                                    <i class="fa fa-arrow-left"></i> Back
                                                </button>
                                            </li>

                                        </ul>
                                    </div>
                                    <?php if ($companies): ?>
                                        <div class="row">
                                            <!-- Company Details Card -->
                                            <div class="col-md-6">
                                                <div class="card">
                                                    <div class="card-header bg-primary text-white">
                                                        <strong>Company Information</strong>
                                                    </div>
                                                    <div class="card-body">
                                                        <table class="table table-striped">
                                                            <tr>
                                                                <th>Company Name</th>
                                                                <td><?php echo htmlspecialchars($companies['company_name']); ?></td>
                                                            </tr>
                                                            <tr>
                                                                <th>Contact Person</th>
                                                                <td><?php echo htmlspecialchars($companies['contact_person'] ?? 'N/A'); ?></td>
                                                            </tr>
                                                            <tr>
                                                                <th>Phone Number</th>
                                                                <td><?php echo htmlspecialchars($companies['phone_number'] ?? 'N/A'); ?></td>
                                                            </tr>
                                                            <tr>
                                                                <th>Email Address</th>
                                                                <td><?php echo htmlspecialchars($companies['email_address'] ?? 'N/A'); ?></td>
                                                            </tr>
                                                            <tr>
                                                                <th>Location</th>
                                                                <td><?php echo htmlspecialchars($companies['location_name']); ?></td>
                                                            </tr>
                                                            <tr>
                                                                <th>Status</th>
                                                                <?php 
                                                                    $company_state = $companies['company_state'];

                                                                    // Assign class and label
                                                                    if ($company_state == 1) {
                                                                        $class = 'bg-success text-white';
                                                                        $label = 'Active';
                                                                    } elseif ($company_state == 0) {
                                                                        $class = 'bg-danger text-white';
                                                                        $label = 'Deactivated';
                                                                    } else {
                                                                        $class = 'bg-secondary text-white';
                                                                        $label = 'Unknown';
                                                                    }
                                                                ?>
                                                                <td class="<?= $class ?>">
                                                                    <?= $label ?>
                                                                </td>
                                                            </tr>

                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <canvas id="categoryDistributionChart" style="height:20px;"></canvas>
                                            </div>
                                        </div>
                                        <br>

                                        <!-- Product Table -->
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="x_title">
                                                    <h3>Stored Products at This Company</h3>
                                                </div>
                                                <?php 
                                                    include_once 'model/stock_model.php';
                                                    $stock_model = new stock_model();
                                                    $stored_products = $stock_model->getProductsByThirdParty($company_id); 
                                                ?>

                                                <?php if (!empty($stored_products)): ?>
                                                    <table class="table table-bordered table-hover">
                                                        <thead class="thead-light">
                                                            <tr>
                                                                <th>#</th>
                                                                <th>Product Name</th>
                                                                <th>Opening Stock</th>
                                                                <th>Quantity</th>
                                                                <th>Minimum Level</th>
                                                                <th>Date Captured</th>
                                                                <th>Status</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php foreach ($stored_products as $index => $row): ?>
                                                                <tr>
                                                                    <td><?php echo $index + 1; ?></td>
                                                                    <td><?php echo htmlspecialchars($row['product_name']); ?></td>
                                                                    <td><?php echo $row['opening_stock']; ?></td>
                                                                    <td><?php echo $row['quantity']; ?></td>
                                                                    <td><?php echo $row['min_level']; ?></td>
                                                                    <td><?php echo date('d F Y H:i:s',strtotime($row['datecaptured'])); ?></td>
                                                                    <td class="<?= $row['product_state'] == 1 ? 'bg-success text-white' : 'bg-secondary text-white' ?>">
                                                                        <?= $row['product_state'] == 1 ? 'Active' : 'Inactive' ?>
                                                                    </td>

                                                                </tr>
                                                            <?php endforeach; ?>
                                                        </tbody>
                                                    </table>
                                                <?php else: ?>
                                                    <div class="alert alert-info">No products stored by this company yet.</div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <?php else: ?>
                                            <div class="alert alert-warning">Company details not found.</div>
                                        <?php endif; ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /page content -->
                <?php 
                    include_once 'footer.php'; 
                ?>
            </div>
            <!-- Modal -->
        <div class="modal fade" id="editCompanyModal" tabindex="-1" role="dialog" 
            aria-labelledby="editCompanyModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="editCompanyModalLabel">Edit Company Details</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <!-- Company Edit Form -->
                        <form id="editCompanyForm" method="POST" action="controllers/company_controller.php">
                            <!-- Hidden input for company_id -->
                            <input type="hidden" id="company_id" name="company_id" value="" readonly>
                            <input type="hidden" id="action" name="action" value="update_third_party_company_details" readonly>

                            <div class="form-group">
                                <label for="company_name">Company Name</label>
                                <input type="text" class="form-control" id="company_name" name="company_name" required>
                            </div>
                            <div class="form-group">
                                <label for="contact_person">Contact Person</label>
                                <input type="text" class="form-control" id="contact_person" name="contact_person" required>
                            </div>
                            <div class="form-group">
                                <label for="phone_number">Phone Number</label>
                                <input type="text" class="form-control" id="phone_number" name="phone_number" required>
                            </div>
                            <div class="form-group">
                                <label for="email_address">Email Address</label>
                                <input type="email" class="form-control" id="email_address" name="email_address" required>
                            </div>
                            <div class="form-group">
                                <label for="location_name">Location</label>
                                <select name="location" class="form-control" id="location" required>
                                    <!-- Locations will be populated here -->
                                </select>
                            </div>
                            
                            <!-- New field for Company State (Enabled/Disabled) -->
                            <div class="form-group">
                                <label for="company_state">Company State</label>
                                <select name="company_state" class="form-control" id="company_state" required>
                                    <option value="1">Enabled</option>
                                    <option value="0">Disabled</option>
                                </select>
                            </div>

                            <button type="submit" class="btn btn-primary">Save Changes</button>
                        </form>
                    </div>

                </div>
            </div>
        </div>

        <?php 
            include_once 'libraries.php'; 
        ?>
        <script>
            const ctx = document.getElementById('categoryDistributionChart').getContext('2d');
            const categoryDistributionChart = new Chart(ctx, {
                type: 'pie',  // Changed to 'pie' from 'doughnut'
                data: {
                    labels: <?= json_encode($categories) ?>,  // Categories fetched from the backend
                    datasets: [{
                        data: <?= json_encode($category_counts) ?>,  // Product counts per category
                        backgroundColor: ['#007bff', '#ffc107', '#28a745', '#dc3545', '#6f42c1'],  // Color palette
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            position: 'bottom',  // Legends at the bottom
                        },
                        title: {
                            display: true,
                            text: 'Product Count by Category'
                        }
                    }
                }
            });
        </script>
        <script>
            function loadCompanyDetails(company_id) {
                // Ensure company_id is treated as a string
                company_id = String(company_id);

                $.ajax({
                    url: 'get_third_party_company_details.php',  // File to fetch company details
                    method: 'POST',
                    data: { company_id: company_id },  // Send the company_id as a string
                    success: function(response) {
                        const company = JSON.parse(response);

                        if (company.error) {
                            alert(company.error);
                        } else {
                            // Populate modal fields with company details
                            $('#company_id').val(company.company_id);
                            $('#company_name').val(company.company_name);
                            $('#contact_person').val(company.contact_person);
                            $('#phone_number').val(company.phone_number);
                            $('#email_address').val(company.email_address);
                            $('#location').val(company.location_id);  // Assuming location_id is in response

                            // Populate the location dropdown
                            populateLocationDropdown(company.location_id);

                            // Set the company state (Enabled/Disabled)
                            $('#company_state').val(company.company_state);
                        }
                    },
                    error: function(error) {
                        console.error('Error fetching company details:', error);
                    }
                });
            }

            // Function to populate the location dropdown
            function populateLocationDropdown(currentLocationId) {
                $.ajax({
                    url: 'get_locations.php',  // New file to fetch locations
                    method: 'POST',
                    success: function(response) {
                        const locations = JSON.parse(response);
                        const locationSelect = $('#location');
                        
                        // Empty the location dropdown
                        locationSelect.empty();

                        // Loop through locations and add them to the dropdown
                        locations.forEach(function(location) {
                            const option = new Option(location.location_name, location.loc_id);
                            if (location.loc_id === currentLocationId) {
                                option.selected = true; // Set the current location as selected
                            }
                            locationSelect.append(option);
                        });
                    },
                    error: function(error) {
                        console.error('Error fetching locations:', error);
                    }
                });
            }
        </script>

    </body>
</html>
