<!DOCTYPE html>
  <html lang="en">
    <head>
      <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
      <!-- Meta, title, CSS, favicons, etc. -->
      <meta charset="utf-8">
      <meta http-equiv="X-UA-Compatible" content="IE=edge">
      <meta name="viewport" content="width=device-width, initial-scale=1">
	    <link rel="icon" href="images/favicon.png" type="image/ico" />
      <title>Powertex LTD</title>
      <?php
        include_once 'css_links.php';
      ?>
    </head>

    <body class="nav-md">
      <div class="container body">
        <div class="main_container">
          
          <?php
            include 'menu_finance.php';
            include_once 'model/warehouse_model.php';
            include_once 'model/stock_model.php';

            if(isset($_GET['warehouse_id'])){

              $warehouse_id = $_GET['warehouse_id'];
              $product_id = $_GET['product_id'];

              $warehouse_model = new warehouse_model();
              $stock_model = new stock_model();

              $warehouseDetails = $warehouse_model->getwarehouseDetails($warehouse_id);

              $stock_movement_history = $stock_model->getStockMovementHistory($warehouse_id, $product_id);
            }

            

          ?>
          <!-- page content -->
          <div class="right_col" role="main">
            <div class="">
              <div class="page-title">
                <div class="title_left">
                  <h3><small><?php echo $warehouseDetails['warehouse_name']?> </small></h3>
                </div>

                <div class="title_right">
                </div>
              </div>
              <div class="clearfix"></div>
              <div class="row">
                <div class="col-md-12 col-sm-12 ">
                  <div class="x_panel">
                    <div class="x_title">
                      <h2>Stock Items</h2>
                      <ul class="nav navbar-right panel_toolbox">
                        <li>
                          <a class="dropdown-item">
                            <form name="export_waresheet" action="generate_pdf.php" method="post">
                              <input type="hidden" name="warehouse_id" value="<?php echo $warehouse_id?>" readonly>
                              <input type="hidden" name="product_id" value="<?php echo $product_id?>" readonly>
                              <input type="hidden" name="history_sheet" value="history_sheet">
                              <button class="btn btn-info btn-sm" type="submit">Export Sheet
                                <i class="fa fa-file-pdf"></i>
                              </button>
                            </form>
                            
                          </a>
                        </li>
                        <li>
                          <a class="dropdown-item" onclick="history.back()">
                            <button class="btn btn-info btn-sm"> 
                              <i class="fa fa-arrow-left"></i> Back
                            </button>
                          </a>
                        </li>
                      </ul>
                      <div class="clearfix"></div>
                    </div>
                    <div class="x_content">
                      <div class="row">
                        <div class="col-sm-12">
                          <table id="warehouse_stock" class="table table-striped table-bordered" style="width:100%">
                            <thead>
                              <tr>
                                <th>Date</th>
                                <th>Product</th>
                                <th>Category</th>
                                <th style="text-align: left;">From</th>
                                <th>From Type</th>                                
                                <th>To</th>
                                <th>To Type</th>
                                <th style="text-align: center;">Direction</th>
                                <th style="text-align: center;">Quantity</th>
                              </tr>
                            </thead>
                            <tbody>
                              <?php foreach ($stock_movement_history as $row): ?>
                                <tr>
                                  <td><?= date('d M Y', strtotime($row['transaction_date'])) ?></td>
                                  <td><?= htmlspecialchars($row['product_name']) ?></td>
                                  <td><?= htmlspecialchars($row['categoryname']) ?></td>
                                  <td><?= $row['from_location'] ?></td>
                                  <td><?= $row['from_type'] ?></td>
                                  <td><?= $row['to_location'] ?></td>
                                  <td><?= $row['to_type'] ?></td>
                                  <td style="text-align:center;color: <?= $row['direction'] === 'IN' ? 'green' : 'red' ?>">
                                      <?= $row['direction'] ?>
                                  </td>
                                  <td style="text-align: center;"><?= $row['quantity'] ?></td>
                                </tr>
                              <?php endforeach; ?>
                            </tbody>


                            
                          </table>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <!-- /page content -->
          <?php
            include_once 'footer.php';
          ?>
        </div>
      </div>
      <?php
        include_once 'libraries.php';
      ?>
      

      
    <script>
      $(document).ready(function () {
          let table = $('#warehouse_stock').DataTable({
              responsive: true,
              ordering: true,
              pageLength: 100,
              language: {
                  emptyTable: "No stock movement history found for this item for the selected warehouse."
              },
              columnDefs: [
                  {
                      targets: -1, // Last column
                      width: "150px",
                      className: "text-center",
                      orderable: false
                  }
              ]
          });

          // Apply Bootstrap classes to the empty row after draw
          table.on('draw', function () {
              $('#warehouse_stock td.dataTables_empty')
                  .addClass('bg-info text-white text-center fw-bold');
          });

          // Search input listener
          $('#search_query').on('keyup', function () {
              table.search(this.value).draw();
          });
      });
  </script>

    </body>
  </html>