<?php
    session_start();
    require 'vendor/autoload.php';  
    require('pdf_header.php');

    include_once 'model/stock_model.php';
    include_once 'model/common_model.php';
    include_once 'model/warehouse_model.php';

    $common_model = new common_model();

    // Get logo dynamically
    $logo = $common_model->getlogo();
    $logo_path = '../finance/images/'.$logo;
    $company_name = $common_model->getCompanyName();
    $company_details = $common_model->getCompanyDetails();
    $company_address = $company_details['address'];
    $country = $company_details['country'];
    $phone_number = $company_details['phone_number'];
    $email = $company_details['email'];
    $company_website = $company_details['website'];



    if(isset($_POST['stock_sheet'])) {
        $location = $_POST['warehouse_id'];
        $start_date = $_POST['start_date'];
        $end_date = $_POST['end_date'];

        $stock_model = new stock_model();
        $warehouse_model = new warehouse_model();

        $stock_sheet = $stock_model->getstockSheet($location, $start_date, $end_date);
        $warehouseDetails = $warehouse_model->getWarehouseDetails($location);

        if(!empty($stock_sheet)) {
            $pdf = new FPDF('L','mm','A4'); // Landscape A4
            $pdf->AddPage();

            // Company / Warehouse header
            addPDFHeader(
                $pdf,
                $warehouseDetails['warehouse_name'],
                $logo_path,
                $company_address,
                $country,
                $phone_number,
                $email,
                $company_website
            );

            $pdf->Ln(5);

            // Stock sheet title + date
            $pdf->SetFont('Arial', 'B', 12);
            $pdf->Cell(0, 8, "Warehouse Stock Sheet: " . $warehouseDetails['warehouse_name'], 0, 1, 'L');

            $pdf->SetFont('Arial', '', 10);
            $pdf->Cell(0, 6, "Date: " . date('d-m-Y'), 0, 1, 'R');

            // Selected period
            $pdf->SetFont('Arial', 'I', 10);
            $pdf->Cell(0, 6, "Period: " . date('d-m-Y', strtotime($start_date)) . " to " . date('d-m-Y', strtotime($end_date)), 0, 1, 'L');

            $pdf->Ln(3);

            // Table header
            $pdf->SetFont('Courier', 'B', 9);
            $pdf->SetFillColor(200,200,200);

            $pdf->Cell(40, 7, 'Product', 1, 0, 'L', true);
            $pdf->Cell(30, 7, 'Category', 1, 0, 'L', true);
            $pdf->Cell(25, 7, 'Opening', 1, 0, 'C', true);
            $pdf->Cell(25, 7, 'Transfer In', 1, 0, 'C', true);
            $pdf->Cell(25, 7, 'Total In', 1, 0, 'C', true);
            $pdf->Cell(25, 7, 'Transfer Out', 1, 0, 'C', true);
            $pdf->Cell(25, 7, 'Sold', 1, 0, 'C', true);
            $pdf->Cell(25, 7, 'Total Out', 1, 0, 'C', true);
            $pdf->Cell(25, 7, 'Closing', 1, 0, 'C', true);
            $pdf->Cell(25, 7, 'Current', 1, 1, 'C', true);

            // Table rows
            $pdf->SetFont('Courier', '', 8);
            $pdf->SetLineWidth(0.1);

            foreach($stock_sheet as $item) {
                $opening = (int)$item['opening_stock'];
                $transfer_in = (int)$item['transfer_in'];
                $transfer_out = (int)$item['transfer_out'];
                $sold = (int)$item['sold'];

                $total_in = $opening + $transfer_in;
                $total_out = $transfer_out + $sold;
                $closing_stock = $total_in - $total_out;
                $current_stock = (int)$item['current_qty'];

                // Conditional row coloring
                if($current_stock == 0) {
                    $pdf->SetFillColor(255, 0, 0); // red
                    $fill = true;
                } elseif($current_stock < $item['min_level']) {
                    $pdf->SetFillColor(255, 255, 0); // yellow
                    $fill = true;
                } else {
                    $fill = false;
                }

                $pdf->Cell(40, 6, $item['product_name'], 1, 0, 'L', $fill);
                $pdf->Cell(30, 6, $item['categoryname'], 1, 0, 'L', $fill);
                $pdf->Cell(25, 6, $opening, 1, 0, 'C', $fill);
                $pdf->Cell(25, 6, $transfer_in, 1, 0, 'C', $fill);
                $pdf->Cell(25, 6, $total_in, 1, 0, 'C', $fill);
                $pdf->Cell(25, 6, $transfer_out, 1, 0, 'C', $fill);
                $pdf->Cell(25, 6, $sold, 1, 0, 'C', $fill);
                $pdf->Cell(25, 6, $total_out, 1, 0, 'C', $fill);
                $pdf->Cell(25, 6, $closing_stock, 1, 0, 'C', $fill);
                $pdf->Cell(25, 6, $current_stock, 1, 1, 'C', $fill);
            }

            // Filename
            $warehouseName = str_replace(' ', '_', $warehouseDetails['warehouse_name']);
            $dateTime = date('Y-m-d_H-i-s');
            $filename = "Warehouse_Stock_sheet_{$warehouseName}_{$dateTime}.pdf";

            $pdf->Output('D', $filename);
        }
    }



    if (isset($_POST['export_products'])) {
        $location = $_POST['warehouse_id'];
        
        $warehouse_model = new warehouse_model();
        $stock_model = new stock_model();

        $warehouse_stock = $stock_model->getproducts($location);
        $warehouseDetails = $warehouse_model->getWarehouseDetails($location);

        if (!empty($warehouse_stock)) {
            // Initialize PDF
            $pdf = new FPDF();
            $pdf->AddPage();

            addPDFHeader($pdf, $warehouseDetails['warehouse_name'], $logo_path, $company_address, $country, $phone_number, $email, $company_website);


            $pdf->SetFont('Courier', 'B', 10); // Use Courier font

            // Set the font for the card number (left aligned)
            $pdf->SetFont('Courier', '', 10);

            // Set the width of the cell to span the whole line (adjust this as needed)
            $pdf->Cell(90, 10, 'Current Warehouse Stock: ' . $warehouseDetails['warehouse_name'], 0, 0); // Card number aligned to the left

            // Set the font for today's date (right aligned)
            $pdf->SetFont('Courier', '', 10);
            $pdf->Cell(0, 10, 'Date: ' . date('d-m-Y'), 0, 1, 'R'); // Date aligned to the right
            $pdf->Ln(3); // Add a bit of space after the row    


            // Set thinner border lines
            $pdf->SetLineWidth(0.1); // Reduce line thickness (default is 0.2)

            // Table Header
            $pdf->SetFont('Courier', 'B', 8);
            $pdf->Cell(40, 7, 'Product Name', 1);
            $pdf->Cell(30, 7, 'Code', 1);
            $pdf->Cell(25, 7, 'Category', 1); // Wider column for description
            $pdf->Cell(40, 7, 'unit', 1, 0, 'L');
            $pdf->Cell(30, 7, 'Current Quantity', 1, 0, 'C');
            $pdf->Cell(25, 7, 'Min Order', 1, 0, 'C');
            $pdf->Ln();

            // Table Rows
            $pdf->SetFont('Courier', '', 8);
            foreach ($warehouse_stock as $transaction) {
                $pdf->Cell(40, 7, $transaction['product_name'], 1);
                $pdf->Cell(30, 7, $transaction['product_code'], 1);
                $pdf->Cell(25, 7, $transaction['categoryname'], 1);
                $pdf->Cell(40, 7, $transaction['unitname'], 1, 0, 'L');
                $pdf->Cell(30, 7, $transaction['quantity'], 1, 0, 'C');
                $pdf->Cell(25, 7, $transaction['min_level'], 1, 0, 'C');
                $pdf->Ln();
            }

            $warehouseName = str_replace(' ', '_', $warehouseDetails['warehouse_name']); // replace spaces with underscores
            $dateTime = date('Y-m-d_H-i-s'); // format: 2025-04-16_14-30-55

            $filename = "Warehouse_Stock_{$warehouseName}_{$dateTime}.pdf";

            $pdf->Output('D', $filename);
        } else {
            echo "No transactions found for this Warehouse.";
        }
    }

    if (isset($_POST['action']) && $_POST['action'] === 'export_sales_report') {


        $location   = $_POST['location']; // or from POST if applicable
        $start_date = $_POST['start_date'];
        $end_date   = $_POST['end_date'];

        include_once 'model/reports_model.php';
        $reports_model = new reports_model();

        /* ================= FETCH DATA ================= */
        $summary        = $reports_model->getSalesSummary($location, $start_date, $end_date);
        $byCategory     = $reports_model->getSalesByCategoryGross($location, $start_date, $end_date);
        $topProducts    = $reports_model->getTopProducts($location, $start_date, $end_date);
        $discounts      = $reports_model->getDiscountSummary($location, $start_date, $end_date);
        $outstanding    = $reports_model->getOutstandingInvoicesSummary($location, $start_date, $end_date);
        $invoiceAging   = $reports_model->getInvoiceAging($location);
        $paymentModes   = $reports_model->getPaymentModesSummary($location, $start_date, $end_date);

        $pdf = new FPDF('L','mm','A4');
        $pdf->AddPage();

        /* ================= HEADER ================= */
        addPDFHeader(
            $pdf,
            $company_name,
            $logo_path,
            $company_address,
            $country,
            $phone_number,
            $email,
            $company_website
        );

        $pdf->Ln(4);
        $pdf->SetFont('Arial','B',14);
        $pdf->Cell(0,8,'Sales Performance Executive Report',0,1,'L');

        $pdf->SetFont('Arial','I',10);
        $pdf->Cell(0,6,"Reporting Period: ".date('d M Y',strtotime($start_date))." - ".date('d M Y',strtotime($end_date)),0,1,'L');

        $pdf->Ln(4);

        /* ================= KPI CARDS ================= */
        $pdf->SetFont('Courier','B',11);
        $pdf->SetFillColor(245,245,245);

        $kpis = [
            'Total Sales'       => $summary['total_sales'],
            'Total Payments'    => $summary['total_payments'],
            'Outstanding'       => $outstanding['total_outstanding'],
            'Cash Sales'        => $summary['total_cash_sales'],
            'Invoice Payments'  => $summary['total_invoice_payments'],
        ];

        $tileWidth = 55;

        foreach ($kpis as $label => $value) {
            $pdf->Cell($tileWidth,10,$label,1,0,'C',true);
        }
        $pdf->Ln();

        $pdf->SetFont('Courier','',11);
        foreach ($kpis as $value) {
            $pdf->Cell($tileWidth,12,number_format($value,2),1,0,'C');
        }
        $pdf->Ln(14);

        /* ================= SALES COMPOSITION ================= */
        $startY = $pdf->GetY();

        /* ---- SALES BY CATEGORY ---- */
        $pdf->SetFont('Courier','B',11);
        $pdf->Cell(130,8,'Sales by Category (Gross)',0,1);

        $pdf->SetFont('Courier','B',9);
        $pdf->SetFillColor(220,220,220);
        $pdf->Cell(60,7,'Category',1,0,'C',true);
        $pdf->Cell(25,7,'Qty Sold',1,0,'C',true);
        $pdf->Cell(30,7,'Sales',1,0,'C',true);
        $pdf->Cell(15,7,'Tax',1,1,'C',true);

        $pdf->SetFont('Courier','',9);
        foreach ($byCategory as $row) {
            $pdf->Cell(60,7,$row['categoryname'],1);
            $pdf->Cell(25,7,$row['qty_sold'],1,0,'C');
            $pdf->Cell(30,7,number_format($row['total_sales'],2),1,0,'R');
            $pdf->Cell(15,7,number_format($row['total_tax'],2),1,1,'R');
        }

        /* ---- PAYMENT MODES ---- */
        $pdf->SetXY(160, $startY);
        $pdf->SetFont('Courier','B',11);
        $pdf->Cell(0,8,'Payment Distribution',0,1);

        $pdf->SetFont('Courier','',10);
        foreach ($paymentModes as $mode) {
            $pdf->SetX(160);
            $pdf->Cell(60,8,$mode['payment_method'],1);
            $pdf->Cell(45,8,number_format($mode['total_amount'],2),1,1,'R');
        }

        $pdf->Ln(10);

        /* ================= FINANCIAL CONTROLS ================= */
        $startY = $pdf->GetY();

        /* ---- DISCOUNTS ---- */
        $pdf->SetFont('Courier','B',11);
        $pdf->Cell(130,8,'Discount Impact Summary',0,1);

        $pdf->SetFont('Courier','',10);
        $pdf->Cell(50,8,'Cash Discounts',1);
        $pdf->Cell(40,8,number_format($discounts['cash_discounts'],2),1,1,'R');

        $pdf->Cell(50,8,'Invoice Discounts',1);
        $pdf->Cell(40,8,number_format($discounts['invoice_discounts'],2),1,1,'R');

        $pdf->Cell(50,8,'Total Discounts',1);
        $pdf->Cell(40,8,number_format($discounts['total_discounts'],2),1,1,'R');

        /* ---- INVOICE AGING ---- */
        $pdf->SetXY(160, $startY);
        $pdf->SetFont('Courier','B',11);
        $pdf->Cell(0,8,'Invoice Aging Overview',0,1);

        $pdf->SetFont('Courier','',10);
        $pdf->Cell(45,8,'0–30 Days',1);
        $pdf->Cell(45,8,number_format($invoiceAging['amt_0_30'],2),1,1,'R');

        $pdf->SetX(160);
        $pdf->Cell(45,8,'31–60 Days',1);
        $pdf->Cell(45,8,number_format($invoiceAging['amt_31_60'],2),1,1,'R');

        $pdf->SetX(160);
        $pdf->Cell(45,8,'61–90 Days',1);
        $pdf->Cell(45,8,number_format($invoiceAging['amt_61_90'],2),1,1,'R');

        $pdf->SetX(160);
        $pdf->Cell(45,8,'90+ Days',1);
        $pdf->Cell(45,8,number_format($invoiceAging['amt_90_plus'],2),1,1,'R');

        /* ================= OUTPUT ================= */
        $filename = "Sales_Report_{$start_date}_to_{$end_date}.pdf";
        $pdf->Output('D', $filename);


    }



