<?php
include_once 'model/transfer_model.php';
include_once 'model/sales_model.php';

$transfer_model = new transfer_model();
$sales_model = new sales_model();

function generateTNNumber() {
    

    // Step 1: Get last TN number from database
    $transfer_model = new transfer_model();
    $last_tn = $transfer_model->getLastTNNumber(); // returns something like "TN00012"

    if ($last_tn) {
        // Remove prefix TN to get only the number
        $numeric_part = intval(str_replace("TN", "", $last_tn));
        $new_seq = $numeric_part + 1;
    } else {
        $new_seq = 1;
    }

    // Step 2: Pad to 5 digits
    $padded = str_pad($new_seq, 5, '0', STR_PAD_LEFT);

    // Step 3: Add prefix
    $tn_number = "TN" . $padded;

    // Step 4: Ensure uniqueness in DB
    while ($transfer_model->documentNumberExists($tn_number)) {
        $new_seq++;
        $padded = str_pad($new_seq, 5, '0', STR_PAD_LEFT);
        $tn_number = "TN" . $padded;
    }

    return $tn_number;
}

function getNextTransferNoteNumber($location_id){
    $sales_model = new sales_model();
    return $sales_model->getNextDocumentNumber('transfer_note', $location_id, 'warehouse');
}

function getNextCashSaleNumber($location_id) {
    $sales_model = new sales_model();
    return $sales_model->getNextDocumentNumber('cash_sale', $location_id, 'warehouse');
}


function getNextInvoiceNumber($location_id) {
    $sales_model = new sales_model();
    $number = $sales_model->getNextDocumentNumber('invoice', $location_id, 'warehouse');
    return $number;
}

function getNextQuotationNumber($location_id) {
    $sales_model = new sales_model();
    $number = $sales_model->getNextDocumentNumber('quotation', $location_id, 'warehouse');
    return $number;
}

function getNextDeliveryNoteNumber($location_id){
    $sales_model = new sales_model();
    $number = $sales_model->getNextDocumentNumber('delivery_note', $location_id, 'warehouse');
    return $number;
}
