<?php

include_once 'config.php';

class branch_model
{
    public $link;

    public function __construct()
    {
        $db_connection = new dbConnection();
        $this->link = $db_connection->connect();
    }

    public function getBranches() {
        try {
            $stmt = $this->link->prepare("SELECT 
                    b.*, 
                    l.location_name,
                    COUNT(bp.product_id) AS product_count,
                    b.branch_state
                FROM 
                    branches b
                LEFT JOIN 
                    locations l ON b.location = l.loc_id
                LEFT JOIN 
                    branch_products bp ON b.branch_id = bp.branch_id
                WHERE 
                    b.branch_state = 1
                GROUP BY 
                    b.branch_id
                ORDER BY 
                    b.branch_name ASC
            ");
            $stmt->execute();
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (PDOException $e) {
            error_log("Get Branches error: " . $e->getMessage());
            return [];
        }
    }
           
}