<?php

include_once 'config.php';

class common_model
{
    public $link;

    public function __construct()
    {
        $db_connection = new dbConnection();
        $this->link = $db_connection->connect();
    }

    public function checkPendingDeliveryNotes($location) {
        $sql = "SELECT COUNT(*) FROM delivery_notes WHERE shop_location = :location AND dn_state = 1";
        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':location', $location, PDO::PARAM_INT);
        $stmt->execute();
        $count = $stmt->fetchColumn();
        return ($count > 0) ? 1 : 0;    
    }

    public function countPendingDeliveryNotes($location) {
        $sql = "SELECT COUNT(*) FROM delivery_notes WHERE shop_location = :location AND dn_state = 1";
        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':location', $location, PDO::PARAM_INT);
        $stmt->execute();
        $count = $stmt->fetchColumn();
        return ($count) ? $count : 0;    
    }

    public function getCompanyDetails() {
        $sql = "SELECT
                ss.location,
                ss.logo,
                ll.location_name,
                ss.address,
                ss.address as postal_address,
                ss.physical_location,
                dd.country,
                ss.phone_number,
                ss.company_phon2 as alt_phone,
                ss.email,
                ll.loc_dist as district,
                dd.district as district_name,
                ss.directors_signature,
                ss.tpin,
                ss.website,
                ss.vat_value as vat_percentage
            FROM 
                settings ss
            LEFT JOIN
                locations ll ON ss.location = ll.loc_id 
            LEFT JOIN
                districts dd ON ll.loc_dist = dd.id
            WHERE ss.id = 1";
    
        $stmt = $this->link ->prepare($sql);
        $stmt->execute();
    
        return $stmt->fetch(PDO::FETCH_ASSOC); // Use fetch() since you're retrieving a single row
    }
    

    public function getLocations($district) {
        $sql = "SELECT loc_id, location_name FROM locations WHERE loc_dist = :district";
    
        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':district', $district, PDO::PARAM_STR);
        $stmt->execute();
    
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    

    
    public function getlogo()
    {
        $sql = "SELECT logo FROM settings WHERE id = 1";
        $stmt = $this->link->prepare($sql);
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        return $result ? $result['logo'] : null;
    }

    
    public function getCompanyName(){
        $sql = "SELECT company_name FROM settings WHERE id = 1";
        $stmt = $this->link->prepare($sql);
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($result && !empty(trim($result['company_name']))) {
            return $result['company_name'];
        }

   
    return 'COMPANY NAME';
    }

    public function getlocationDetails($loc_id) {
        $sql = "SELECT 
                    ll.loc_id, 
                    ll.location_name,
                    dd.district AS district_name,
                    dd.region,
                    ll.loc_dist,
                    ll.loc_dist,
                    ll.location_state,
                    if(ll.location_state = 1, 'Active Location', 'Disabled Location') as location_status
                FROM 
                    locations ll
                LEFT JOIN 
                    districts dd ON ll.loc_dist = dd.id
                WHERE 
                    ll.loc_id = :loc_id
                LIMIT 1";
    
        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':loc_id', $loc_id, PDO::PARAM_STR);
        $stmt->execute();
    
        return $stmt->fetch(PDO::FETCH_ASSOC); // returns a single location detail row
    }

    

    public function checkPendingTransferRequest() {
        $sql = "SELECT COUNT(*) as transfers
            FROM 
                stock_transfers_final p
            WHERE
                p.transfer_state = 1
        ";

        $stmt = $this->link->prepare($sql);
        $stmt->execute();

        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        return ($result['transfers'] > 0) ? 1 : 0;
    }

    

    public function verifyLocation(string $location_id): ?array {
        $stmt = $this->link->prepare("SELECT * FROM locations WHERE loc_id = :location_id LIMIT 1");
        $stmt->bindParam(':location_id', $location_id, PDO::PARAM_STR);
        $stmt->execute();

        $location = $stmt->fetch(PDO::FETCH_ASSOC);
        return $location ?: null;
    }

    

    public function countIncompleteOrders($employee_code) {
        $query = "SELECT
                    COUNT(DISTINCT so.sales_number) AS total_incomplete_cash_orders
                FROM 
                    sales_order so
                LEFT JOIN 
                    payments py ON so.sales_number = py.sale_id
                WHERE 
                    (
                        py.sale_id IS NULL -- No payment made
                        OR (py.sale_id IS NOT NULL AND py.payment_state = 0)
                    )
                    AND so.type = 'Cash Sale'
                    AND so.operator =:operator";

        $stmt = $this->link->prepare($query);
        $stmt->bindParam(':operator', $employee_code, PDO::PARAM_INT);
        $stmt->execute();
        $count = $stmt->fetchColumn();

        return ($count > 0) ? 1 : 0;
    }
    
    public function checkIncompleteTransfers($employee_code) {
        $query = "SELECT
                    COUNT(DISTINCT sti.transfer_id) AS total_incomplete_transfers
                FROM 
                    stock_transfer_items sti
                LEFT JOIN 
                    stock_transfers_final stf ON sti.transfer_id = stf.transfer_id
                WHERE 
                    stf.transfer_id IS NULL
                    AND sti.operator =:operator";

        $stmt = $this->link->prepare($query);
        $stmt->bindParam(':operator', $employee_code, PDO::PARAM_INT);
        $stmt->execute();
        $count = $stmt->fetchColumn();

        return ($count > 0) ? 1 : 0;
    }

    public function getIncompleteTransactions($employee_code) {
        try {
            $sql = "SELECT 
                        sti.transfer_id AS transaction_id,
                        MIN(sti.transfer_date) AS transaction_date,
                        'Stock Transfer' AS transaction_type,
                        CASE 
                            WHEN b.branch_id IS NOT NULL THEN CONCAT('Branch: ', b.branch_name)
                            WHEN w2.warehouse_id IS NOT NULL THEN CONCAT('Warehouse: ', w2.warehouse_name)
                            ELSE 'Unknown'
                        END AS reference_info,
                        COUNT(sti.id) AS item_count,
                        CONCAT('initiate_transfer.php?tn_number=', sti.transfer_id) AS resume_url
                    FROM 
                        stock_transfer_items sti
                    LEFT JOIN 
                        stock_transfers_final stf ON sti.transfer_id = stf.transfer_id
                    LEFT JOIN 
                        warehouses w ON sti.transfer_from = w.warehouse_id
                    LEFT JOIN 
                        warehouses w2 ON sti.transfer_to = w2.warehouse_id
                    LEFT JOIN 
                        branches b ON sti.transfer_to = b.branch_id
                    WHERE 
                        stf.transfer_id IS NULL
                        AND sti.operator = :operator
                    GROUP BY 
                        sti.transfer_id
                UNION ALL
                    SELECT 
                        so.sales_number AS transaction_id,
                        MIN(so.date_captured) AS transaction_date,
                        CASE 
                            WHEN so.type = 'Cash Sale' THEN 'Cash Sale'
                            WHEN so.type = 'Customer Order' THEN 'Customer Order'
                            ELSE 'Sale'
                        END AS transaction_type,
                        COALESCE(so.sales_number,'') AS reference_info,
                        COUNT(soi.id) AS item_count,
                        CONCAT('new_cash_sale.php?cash_sale_number=', so.sales_number) AS resume_url
                    FROM
                        sales_order so
                    LEFT JOIN
                        sales_order soi ON so.sales_number = soi.sales_number
                    LEFT JOIN
                        payments py ON so.sales_number = py.sale_id
                    WHERE
                        (
                            py.sale_id IS NULL -- No payment made
                            OR (py.sale_id IS NOT NULL AND py.payment_state = 0)
                        )
                        AND so.operator = :operator
                        AND so.type = 'Cash Sale'
                    GROUP BY
                        so.sales_number
                UNION ALL
                    SELECT 
                        so.sales_number AS transaction_id,
                        MIN(so.date_captured) AS transaction_date,
                        'Customer Order' AS transaction_type,
                        COALESCE(so.sales_number,'') AS reference_info,
                        COUNT(soi.id) AS item_count,
                        CONCAT('new_customer_invoice.php?invoice_number=', so.sales_number) AS resume_url
                    FROM
                        sales_order so
                    LEFT JOIN
                        sales_order soi ON so.sales_number = soi.sales_number
                    LEFT JOIN
                        saved_orders py ON so.sales_number = py.order_number
                    WHERE
                        py.order_number IS NULL
                        AND so.operator = :operator
                        AND so.type = 'Customer Order'
                    GROUP BY
                        so.sales_number
                    ORDER BY 
                        transaction_date DESC;";

            $stmt = $this->link->prepare($sql);
            $stmt->bindParam(':operator', $employee_code, PDO::PARAM_STR);
            $stmt->execute();
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        } catch (PDOException $e) {
            error_log("Get Incomplete Transfers Error: " . $e->getMessage());
            return [];
        }
    }


    
    public function countIncompleteTransfers($employee_code) {
        $query = "SELECT
                    COUNT(DISTINCT sti.transfer_id) AS total_incomplete_transfers
                FROM 
                    stock_transfer_items sti
                LEFT JOIN 
                    stock_transfers_final stf ON sti.transfer_id = stf.transfer_id
                WHERE 
                    stf.transfer_id IS NULL
                    AND sti.operator =:operator";

        $stmt = $this->link->prepare($query);
        $stmt->bindParam(':operator', $employee_code, PDO::PARAM_INT);
        $stmt->execute();
        $count = $stmt->fetchColumn();

        return ($count > 0) ? $count : 0;
    }

    public function getuserDetails($username) {
        $query = "SELECT
                u.employee_code,
                emp.phone_number,
                emp.email_address,
                emp.current_location as loc,
                emp.home_district as hom_dis,
                la.location_name,
                ll.location_name as assigned_location,
                emp.home_village,
                emp.gender,
                u.reports,
                u.customers,
                u.users,
                u.cash_trans,
                u.employees,
                u.stock,
                CASE
                    WHEN u.role = 'SysAdmin' THEN 'System Administrator'
                    WHEN u.role = 'Administrator' THEN 'Chief Administrator'
                    ELSE u.role
                END as role,
                u.username,
                d.district as home_district,
                CASE 
                    WHEN u.employee_code IN(2000, 2001) THEN 'Super User'
                    WHEN emp.fullname IS NULL THEN 'UNKNOWN'
                    ELSE emp.fullname
                END AS fullname,
                CASE 
                    WHEN u.avatar IS NULL THEN 'default_avatar.png'
                    ELSE u.avatar
                END AS avatar,
                COALESCE(ll.login_count, 0) AS login_count
            FROM 
                users u
            LEFT JOIN
                employees emp ON u.employee_code = emp.employee_code
            LEFT JOIN
                locations la ON emp.current_location = la.loc_id
            LEFT JOIN
                locations ll ON u.location = ll.loc_id
            LEFT JOIN
                districts d ON emp.home_district = d.id
            LEFT JOIN
                (
                    SELECT username, COUNT(*) AS login_count
                    FROM logins
                    GROUP BY username
                ) ll ON u.username = ll.username
               WHERE
               		u.username = :username";
        
        $stmt = $this->link->prepare($query);
        $stmt->bindParam(':username', $username, PDO::PARAM_STR);
        $stmt->execute();
        
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function checkIncompleteCashSales($employee_code, $location){
        // Implementation for checking incomplete cash sales
        $sql = "SELECT 
                    COUNT(DISTINCT so.sales_number) AS total_incomplete_cash_sales
                FROM 
                    sales_order so
                LEFT JOIN 
                    payments py ON so.sales_number = py.sale_id
                WHERE 
                    (
                        py.sale_id IS NULL -- No payment made
                        OR (py.sale_id IS NOT NULL AND py.payment_state = 0)
                    )
                    AND so.type = 'Cash Sale'
                    AND so.operator =:operator
                    AND so.department =:location";
        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':operator', $employee_code, PDO::PARAM_INT);
        $stmt->bindParam(':location', $location, PDO::PARAM_INT);
        $stmt->execute();
        $count = $stmt->fetchColumn();
        return ($count > 0) ? 1 : 0;
    }

    public function checkIncompleteInvoices($employee_code, $location){
        // Implementation for checking incomplete invoices
        $sql = "SELECT 
                    COUNT(DISTINCT so.sales_number) AS total_incomplete_invoices
                FROM 
                    sales_order so
                LEFT JOIN 
                    saved_orders py ON so.sales_number = py.order_number
                WHERE 
                    py.order_number IS NULL 
                    AND so.type = 'Customer Order'
                    AND so.operator =:operator
                    AND so.department =:location";
        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':operator', $employee_code, PDO::PARAM_INT);
        $stmt->bindParam(':location', $location, PDO::PARAM_INT);
        $stmt->execute();
        $count = $stmt->fetchColumn();
        return ($count > 0) ? 1 : 0;
    }

    public function countIncompleteInvoices($employee_code, $location) {
        $query = "SELECT
                    COUNT(DISTINCT so.sales_number) AS total_incomplete_invoices
                FROM 
                    sales_order so
                LEFT JOIN 
                    saved_orders py ON so.sales_number = py.order_number
                WHERE 
                    py.order_number IS NULL 
                    AND so.type = 'Customer Order'
                    AND so.operator =:operator
                    AND so.department=:location";

        $stmt = $this->link->prepare($query);
        $stmt->bindParam(':operator', $employee_code, PDO::PARAM_INT);
        $stmt->bindParam(':location', $location, PDO::PARAM_INT);
        $stmt->execute();
        $count = $stmt->fetchColumn();

        return ($count > 0) ? $count : 0;
    }

    public function getPermissions($username){
        $sql = "SELECT payments_display, sales_display FROM users WHERE username =:username";
        $smtp = $this->link->prepare($sql);
        $smtp->bindParam(':username', $username, PDO::PARAM_STR);
        $smtp->execute();
        $permission_values = $smtp->fetch();
        return $permission_values;

    }

    public function countIncompleteCashSales($employee_code, $location) {
        $query = "SELECT
                    COUNT(DISTINCT so.sales_number) AS total_incomplete_cash_sales
                FROM 
                    sales_order so
                LEFT JOIN 
                    payments py ON so.sales_number = py.sale_id
                WHERE 
                    (
                        py.sale_id IS NULL -- No payment made
                        OR (py.sale_id IS NOT NULL AND py.payment_state = 0)
                    )
                    AND so.type = 'Cash Sale'
                    AND so.operator =:operator
                    AND so.department =:location";

        $stmt = $this->link->prepare($query);
        $stmt->bindParam(':operator', $employee_code, PDO::PARAM_INT);
        $stmt->bindParam(':location', $location, PDO::PARAM_INT);
        $stmt->execute();
        $count = $stmt->fetchColumn();

        return ($count > 0) ? $count : 0;
    }

    

    public function countIncompleteSaless($employee_code) {
        $query = "SELECT
                    COUNT(DISTINCT so.sales_number) AS total_incomplete_cash_sales
                FROM 
                    sales_order so
                LEFT JOIN 
                    payments py ON so.sales_number = py.sale_id
                WHERE 
                    (
                        py.sale_id IS NULL -- No payment made
                        OR (py.sale_id IS NOT NULL AND py.payment_state = 0)
                    )
                    AND so.type = 'Customer Order'
                    AND so.operator =:operator";

        $stmt = $this->link->prepare($query);
        $stmt->bindParam(':operator', $employee_code, PDO::PARAM_INT);
        $stmt->execute();
        $count = $stmt->fetchColumn();

        return ($count > 0) ? 1 : 0;
    }

    public function hasPendingTransfers($location) {
        $sql = "SELECT COUNT(*) FROM stock_transfers_final WHERE transfer_to = :location AND transfer_state = 1";
        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':location', $location, PDO::PARAM_INT);
        $stmt->execute();
        $count = $stmt->fetchColumn();
        return ($count > 0) ? 1 : 0;    
    }

    public function countTransfers($location) {
        $sql = "SELECT COUNT(*) FROM stock_transfers_final WHERE transfer_to = :location AND transfer_state = 1";
        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':location', $location, PDO::PARAM_INT);
        $stmt->execute();
        $count = $stmt->fetchColumn();
        return $count;  
    }   

    public function getAllLocations() {
        $sql = "SELECT 
                ll.loc_id, 
                ll.location_name,
                dd.district AS district_name,
                ll.location_state,
                dd.region,
                IF(ll.location_state = 1, 'Active Location', 'Disabled Location') as location_status,
                (
                    SELECT COUNT(*) FROM warehouses w WHERE w.location = ll.loc_id
                ) +
                (
                    SELECT COUNT(*) FROM branches b WHERE b.location = ll.loc_id
                ) +
                (
                    SELECT COUNT(*) FROM employees e WHERE e.current_location = ll.loc_id
                ) +
                (
                    SELECT COUNT(*) FROM customers c WHERE c.location = ll.loc_id
                ) +
                (
                    SELECT COUNT(*) FROM third_party_companies t WHERE t.location = ll.loc_id
                ) AS total_usage
            FROM 
                locations ll
            LEFT JOIN
                districts dd ON ll.loc_dist = dd.id
            WHERE 
                ll.location_state = 1
            ORDER BY
                ll.location_name ASC";
    
        $stmt = $this->link->prepare($sql);
        $stmt->execute();
    
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getDistricts() {
        $sql = "SELECT id, district FROM districts ORDER BY district ASC";
        $stmt = $this->link->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getNationalities() {
        $sql = "SELECT id, country_name, nationality, capital_city, phone_code FROM countries order by country_name ASC";
        $stmt = $this->link->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function addNewLocation($loc_id, $new_location_name, $new_location_district, $location_state) {
        $sql = "INSERT INTO locations (loc_id, location_name, loc_dist, location_state) VALUES (:location_id, :location_name, :loc_dist, :location_state)";
        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':location_id', $loc_id, PDO::PARAM_STR);
        $stmt->bindParam(':location_name', $new_location_name, PDO::PARAM_STR);
        $stmt->bindParam(':loc_dist', $new_location_district, PDO::PARAM_INT);
        $stmt->bindParam(':location_state', $location_state, PDO::PARAM_INT);
        
        if($stmt->execute()){
            return true;
        } else {
            return false;
        }
        
    }

    public function getNextLocationId() {
    // Query the highest existing loc_id (assuming format LOC001, LOC002...)
        $sql = "SELECT loc_id FROM locations ORDER BY loc_id DESC LIMIT 1";
        $stmt = $this->link->prepare($sql);
        $stmt->execute();

        $last = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($last) {
            // Remove prefix and convert numeric portion
            $num = (int) substr($last['loc_id'], 3);
            $num++;
            // Rebuild ID with prefix
            return 'LOC' . str_pad($num, 3, '0', STR_PAD_LEFT);
        } else {
            // First location in system
            return 'LOC001';
        }
    }

    public function checkProductsBelowMinOrderLevel($location){
        $sql = "SELECT
                    COUNT(product_id) 
                FROM 
                    warehouse_products 
                WHERE 
                    warehouse_id = :warehouse 
                    AND quantity <= min_level 
                    AND quantity > 0";

        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':warehouse', $location, PDO::PARAM_INT);
        $stmt->execute();

        $count = (int) $stmt->fetchColumn();

        return ($count > 0) ? 1 : 0;
    }

    public function checkProductsoutofStock($location){
        $sql = "SELECT
                    COUNT(product_id) 
                FROM 
                    warehouse_products 
                WHERE 
                    warehouse_id = :warehouse
                    AND quantity = 0";

        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':warehouse', $location, PDO::PARAM_INT);
        $stmt->execute();

        $count = (int) $stmt->fetchColumn();

        return ($count > 0) ? 1 : 0;
    }
    
    public function countNotifications($receiver){
        $sql = "SELECT 
                EXISTS 
                (
                    SELECT 1
                    FROM 
                        notifications
                    WHERE 
                        receiver = :receiver
                        AND notificaton_state = 0
                    ) AS has_notifications";

        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':receiver', $receiver, PDO::PARAM_INT);
        $stmt->execute();

        return (int) $stmt->fetchColumn(); // returns 1 or 0
    }

    public function markAsRead($notification_id){
        $sql = "UPDATE 
                    notifications
                SET 
                    notificaton_state = 1
                WHERE 
                    id = :id";

        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':id', $notification_id, PDO::PARAM_INT);

        return $stmt->execute();
    }

    public function fetchNotificationsData($emp_code){
        $sql = "SELECT 
                    n.id,
                    sender,
                    receiver,
                    purpose,
                    identifier,
                    COALESCE(stf.transfer_to,'') as transfer_to,    
                    message,
                    n.datecaptured,
                    notificaton_state
                FROM 
                    notifications n
                LEFT JOIN
                    stock_transfers_final stf ON n.identifier = stf.transfer_id
                WHERE 
                    receiver = :receiver
                ORDER BY 
                    datecaptured DESC";

        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':receiver', $emp_code, PDO::PARAM_INT);
        $stmt->execute();

        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }


       
    
}