<?php

include_once 'config.php';

class users_model
{
    public $link;

    public function __construct()
    {
        $db_connection = new dbConnection();
        $this->link = $db_connection->connect();
    }

    public function getPasswordByUsername($username) {
        $sql = "SELECT password FROM users WHERE username = :username";
        $stmt = $this->link->prepare($sql);

        if ($stmt === false) {
            // Handle error in preparing the statement
            error_log("SQL Error: " . $this->link->errorInfo());
            return null;
        }
        
        // Bind the username parameter to the prepared statement
        $stmt->bindParam(':username', $username, PDO::PARAM_STR); 
        $stmt->execute();
        
        // Fetch the result
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($result) {
            return $result['password'];
        } else {
            return null; // No user found with that username
        }
    }

    public function fetchLocation($username, $employee_code){
        $sql = "SELECT 
                    location as warehouse_id
            FROM 
                users
            WHERE 
                employee_code = :employee_code
                AND username = :username
        ";

        $stmt = $this->link->prepare($sql); 
        $stmt->bindParam(':employee_code', $employee_code, PDO::PARAM_INT);
        $stmt->bindParam(':username', $username, PDO::PARAM_STR);
        $stmt->execute();

        // Fetch a single row
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        return $row ? $row['warehouse_id'] : null;
    }

    public function cancelActive($username){
        $sql = "UPDATE logins SET active_session = 0 WHERE username = :username";
        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':username', $username, PDO::PARAM_STR);
        
        if($stmt->execute()){
            return true;
        }else{
            return false;
        }
    }

    public function logoutUpdates($logout_time, $session_id){
        $sql = "UPDATE logins SET logout_time = :logout_time WHERE session_id = :session_id";
        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':logout_time', $logout_time, PDO::PARAM_STR);
        $stmt->bindParam(':session_id', $session_id, PDO::PARAM_STR);
        
        if($stmt->execute()){
            return true;
        }else{
            return false;
        }
    }

    public function changePassword($username, $password){
        $sql = "UPDATE users SET password = :password WHERE username = :username";
        $stmt = $this->link->prepare($sql);
        $stmt->bindParam(':username', $username, PDO::PARAM_STR);
        $stmt->bindParam(':password', $password, PDO::PARAM_STR);
        
        if($stmt->execute()){
            return true;
        }else{
            return false;
        }
    }

           
}