    <?php 
    include('menu_supervisor.php');
    include_once 'model/stock_model.php';
    include_once 'model/warehouse_model.php';
    include_once 'model/customers_model.php';
    include_once 'model/common_model.php';

    $stock_model = new stock_model();
    $warehouse_model = new warehouse_model();
    $customer_model = new customers_model();
    $common_model = new common_model();

    $companyDetails = $common_model->getCompanyDetails();

    $cash_sale_number = $_GET['cash_sale_number'] ?? "N/A";
    $products = $stock_model->getproducts($location);
    $warehouseDetails = $warehouse_model->getWarehouseDetails($location);
    $customers = $customer_model->getCustomers($location, ['Walk-In', 'Dealer','Corporate', 'Individual'], [1,2]);
    $vat_value = $companyDetails['vat_percentage'];
    $locked_customer_id = isset($_GET['customer_id']) ? (int)$_GET['customer_id'] : 0;
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Powertex || New Cash Sale</title>

    <link rel="icon" type="image/png" href="../finance/images/favicon.png">

    <style>
    .summary-box h5, .summary-box h3 { margin: 8px 0; }
    </style>
    <style>
    /* Summary font adjustments */
    .summary-box, 
    .summary-box h5, 
    .summary-box h3, 
    #subTotal, 
    #vatAmount, 
    #grandTotal {
        font-family: "Times New Roman", serif !important;
    }

    /* Sizes + colors */
    .summary-box h5 {
        font-size: 18px;
        color: #333;
    }

    .summary-box h3 {
        font-size: 24px;
        color: #0a7d12; /* Green total */
    }
     /* Make Select2 match Bootstrap form-control styling */
.select2-container .select2-selection--single {
    height: 38px !important;
    padding: 6px 12px;
    border: 1px solid #ced4da !important;
    border-radius: 4px !important;
    background-color: #fff !important;
}

.select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 26px !important;
    color: #495057 !important;
    font-size: 17   px;
}

.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 36px !important;
    right: 8px;
}

/* Focus style same as Bootstrap */
.select2-container--default.select2-container--focus .select2-selection--single {
    border-color: #80bdff !important;
    box-shadow: 0 0 0 0.2rem rgba(0,123,255,.25) !important;
    outline: 0;
}

/* Match input height also for multiple select (if you use it later) */
.select2-container .select2-selection--multiple {
    min-height: 38px !important;
    border: 1px solid #ced4da !important;
    border-radius: 4px !important;
}
    </style>

    </head>

    <body class="hold-transition sidebar-mini layout-fixed">

    <div class="content-wrapper p-4">

        <div class="mb-4">
            <h4 class="text-primary"><i class="fa fa-shopping-cart"></i> New Cash Sale</h2>
        </div>

        <!-- HEADER INFORMATION - Cash Sale -->
        <div class="card shadow-sm mb-4">
            <div class="card-body row">

                <div class="col-md-3">
                    <label><strong>Warehouse</strong></label>
                    <input type="text" class="form-control" value="<?= htmlspecialchars($warehouseDetails['warehouse_name']) ?>" readonly>
                    <input type="hidden" id="warehouse_id" name="warehouse_id" value="<?= $location ?>" readonly>
                </div>
                
                <div class="col-md-3">
                    <label><strong>Cash Sale Number</strong></label>
                    <input type="text" class="form-control" id="cash_sale_number" name="cash_sale_number" value="<?= htmlspecialchars($cash_sale_number) ?>" readonly>
                </div>

                <div class="col-md-3">
                    <label><strong>Date</strong></label>
                    <input type="date" class="form-control" id="cash_sale_date" name="cash_sale_date"  max="<?= date('Y-m-d'); ?>" value="<?= date('Y-m-d') ?>" required>
                </div>

                <div class="col-md-3">
    <label><strong>Customer</strong></label>
    <select id="customer_id" class="select2" style="width:100%" required <?= $locked_customer_id ? 'data-locked="1"' : '' ?>>
        <option value="">-- Select Customer --</option>
        <option value="Walk-In">Walk In Customer</option>
        <?php foreach ($customers as $c): ?>
            <option 
                value="<?= $c['customer_id'] ?>" 
                data-balance="<?= $c['outstanding_balance'] ?>">
                <?= htmlspecialchars($c['customer_name']) ?>
            </option>
        <?php endforeach; ?>
    </select>
</div>

<!-- WALK-IN CUSTOMER DETAILS -->
<div class="col-md-12 mt-3" id="walkin_fields" style="display:none;">
    <div class="row justify-content-end">
        
        <!-- NAME -->
        <div class="col-md-3">
            <label><strong>Customer Name</strong></label>
            <input 
                type="text" 
                id="walkin_name" 
                class="form-control" 
                placeholder="Enter customer name">
        </div>

        <!-- PHONE -->
        <div class="col-md-3">
            <label><strong>Phone Number</strong></label>
            <div class="input-group">
                <div class="input-group-prepend">
                    <span class="input-group-text">
                        🇲🇼 +265
                    </span>
                </div>
                <input 
                    type="text" 
                    id="walkin_phone" 
                    class="form-control"  maxlength="9"
                    placeholder="e.g. 123 456 789">
            </div>
        </div>

    </div>
</div>


            </div>
        </div>


        <!-- PRODUCT ENTRY -->
        <div class="card shadow-sm mb-4">
            <div class="card-header bg-primary text-white">
                <strong>Add Product</strong>
            </div>

            <div class="card-body">
                <div class="row">

                    <!-- Product Dropdown -->
                    <div class="col-md-4">
                        <label><strong>Product</strong></label>
                        <select id="product_select" class="form-control select2">
                            <option value="">-- Select Product --</option>
                            <?php foreach ($products as $p): ?>
                                <option 
                                    value="<?= $p['product_id'] ?>"
                                    data-name="<?= $p['product_name'] ?>"
                                    data-price="<?= $p['selling_price'] ?>"
                                    data-stock="<?= $p['quantity'] ?>"
                                    data-category="<?= $p['categoryname'] ?>"
                                >
                                    <?= $p['product_name'] ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <!-- Stock -->
                    <div class="col-md-2">
                        <label><strong>Stock</strong></label>
                        <input type="text" id="current_stock" class="form-control" readonly>
                    </div>

                    <!-- Price -->
                    <div class="col-md-2">
                        <label><strong>Price</strong></label>
                        <input type="text" id="selling_price" class="form-control" required>
                    </div>

                    <!-- Qty -->
                    <div class="col-md-2">
                        <label><strong>Qty</strong></label>
                        <input type="number" id="qty" class="form-control" min="1" value="1">
                    </div>

                    <!-- Add Button -->
                    <div class="col-md-2">
                        <label>&nbsp;</label>
                        <button id="addItemBtn" class="btn btn-success btn-block">
                            Add <i class="fa fa-plus"></i>
                        </button>
                    </div>

                </div>
            </div>
        </div>


        <!-- ITEMS TABLE + SUMMARY -->
        <div class="row">

            <!-- LEFT: CASH SALE ITEMS TABLE -->
            <div class="col-md-7">
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-dark text-white">
                        <strong>Cash Sale Items</strong>
                    </div>

                    <div class="card-body table-responsive">
                        <table class="table table-bordered table-striped" id="cashSaleTable">
                            <thead class="thead-dark">
                                <tr>
                                    <th>Product</th>
                                    <th width="12%">Price</th>
                                    <th width="10%">Qty</th>
                                    <th width="15%">Total</th>
                                    <th width="5%">×</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- RIGHT: SUMMARY -->
            <div class="col-md-5">
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-secondary text-white">
                        <strong>Summary</strong>
                    </div>

                    <div class="card-body">
                        <div class="form-group mb-4">
    <div class="custom-control custom-checkbox">
        <input type="checkbox" class="custom-control-input" id="split_payment">
        <label class="custom-control-label" for="split_payment">Split Payment</label>
    </div>
</div>

<div id="splitPaymentContainer" style="display:none;">
    <div id="splitPaymentRows"></div>
    <button type="button" class="btn btn-secondary btn-sm" id="addSplitPaymentRow">
        Add Payment Method
    </button>
</div>


                        <!-- PAYMENT METHOD -->
                        <div class="form-group mb-4">
                            <label><strong>Payment Method</strong></label>
                            <select id="payment_method" class="form-control" required>
                                <option value="">-- Select Payment Method --</option>
                                <option value="Cash">Cash</option>
                                <option value="Airtel Money">Airtel Money</option>
                                <option value="Visa">Visa</option>
                                <option value="Online Transfer">Online Transfer</option>
                                <option value="Cheque">Cheque</option>
                                <option value="Mpamba">Mpamba</option>
                            </select>
                        </div>

                        <!-- TRANSACTION ID (only shown when NOT cash) -->
                        <div class="form-group mb-4" id="transaction_id_group" style="display:none;">
                            <label><strong>Transaction ID</strong></label>
                            <input type="text" id="transaction_id" class="form-control" placeholder="Enter Transaction ID">
                        </div>

                        <div class="form-group mb-3">
    <div class="row">
        <div class="col-md-6">
            <div class="custom-control custom-checkbox">
                <input type="checkbox" class="custom-control-input" id="apply_vat" checked>
                <label class="custom-control-label" for="apply_vat">
                    Apply VAT (<?= number_format($vat_value * 100, 2) ?>%)
                </label>
            </div>
        </div>

        <div class="col-md-6 text-right">
            <div class="custom-control custom-checkbox">
                <input 
                    type="checkbox" 
                    class="custom-control-input" 
                    id="scrap_collected"
                >
                <label class="custom-control-label" for="scrap_collected">
                    Scrap Collected
                </label>
            </div>
        </div>
        <!-- Scrap Quantity input, hidden by default -->
        <div class="col-md-12 mt-2" id="scrap_quantity_group" style="display:none;">
            <label><strong>Scrap Quantity</strong></label>
            <input type="number" id="scrap_quantity" class="form-control" min="1" value="1">
        </div>
    </div>
</div>


                    



                        <div class="form-group">
                            <label><strong>Discount</strong></label>
                            <input type="number" id="discount" class="form-control" value="0" min="0">
                        </div>

                        <div class="p-3 border rounded bg-light summary-box">

                            <h5>
                                Subtotal 
                                <span class="float-right" id="subTotal">0.00</span>
                            </h5>

                            <h5>
                                Discount 
                                <span class="float-right" id="discountAmount">0.00</span>
                            </h5>
                            

                            <h5>
                                VAT 
                                <span class="float-right" id="vatAmount">0.00</span>
                            </h5>

                            <hr>

                            <h3 class="text-success">
                                Total 
                                <span class="float-right" id="grandTotal">0.00</span>
                            </h3>
                            <div id="splitPaymentSummary" class="mt-2">
                                <strong>Total Applied:</strong> <span id="splitTotalApplied">0.00</span>
                                <span id="splitWarning" style="color:red; margin-left:10px;"></span>
                            </div>


                        </div>

                        <button class="btn btn-primary btn-lg btn-block mt-3" id="saveCashSaleBtn">
                            <i class="fa fa-check-circle"></i> Save Cash Sale
                        </button>

                    </div>
                </div>
            </div>

        </div>

    </div>

    <!-- Scripts -->
    <script src="../includes/plugins/jquery/jquery.min.js"></script>
    <script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="../includes/dist/js/adminlte.js"></script>
    <script src="../includes/plugins/select2/js/select2.min.js"></script>

     <script>
        const LOCKED_CUSTOMER_ID = <?= $locked_customer_id ?>;

        if (LOCKED_CUSTOMER_ID > 0) {

            // Preselect customer
            $("#customer_id")
                .val(LOCKED_CUSTOMER_ID)
                .trigger("change");

            // Disable Select2 UI (but keep value accessible)
            $("#customer_id").prop("disabled", true);
            $("#customer_id").select2();

        }


        let TOTALS = {
    subTotal: 0,
    vatAmount: 0,
    grandTotal: 0,
    discount: 0
};


        const paymentOptions = ["Cash","Airtel Money","Visa","Online Transfer","Cheque","Mpamba"];
let splitPaymentCounter = 0;

// Toggle split payment container
$("#split_payment").change(function(){
    if($(this).is(":checked")) {
        $("#payment_method, #transaction_id_group").prop("disabled", true);
        $("#splitPaymentContainer").slideDown();
        addSplitPaymentRow(); // Add initial row
    } else {
        $("#payment_method, #transaction_id_group").prop("disabled", false);
        $("#splitPaymentContainer").slideUp();
        $("#splitPaymentRows").empty();
    }
});

// ----------------- Track Split Payment Totals -----------------
function updateSplitPaymentTotal() {
    let grandTotal = TOTALS.grandTotal; // instead of parsing #grandTotal text



    let sum = 0;

    $(".split-amount").each(function () {
        sum += parseFloat($(this).val()) || 0;
    });

    $("#splitTotalApplied").text(formatNumberWithCommas(sum));


    // HARD STOP: sum exceeds total
    if (sum > grandTotal) {
        Swal.fire(
            "Invalid Amounts",
            "Total split payments cannot exceed the total cash sale.",
            "error"
        );
        return false;
    }

    // EXACT MATCH → LOCK INPUTS
    if (sum === grandTotal && grandTotal > 0) {
        $("#splitWarning").text("");
        $("#saveCashSaleBtn").prop("disabled", false);

        $(".split-amount").each(function () {
            $(this).prop("readonly", true);
        });

        return true;
    }

    // BELOW TOTAL → UNLOCK INPUTS
    $(".split-amount").each(function () {
        $(this).prop("readonly", false);
    });

    $("#splitWarning").text(
        `Remaining amount: ${(grandTotal - sum).toFixed(2)}`
    );
    $("#saveCashSaleBtn").prop("disabled", true);

    return true;
}


$(document).on("input", ".split-amount", function () {
    let grandTotal = parseNumber($("#grandTotal").text());


    if (grandTotal === 0) {
        Swal.fire(
            "No Items Added",
            "Add products before entering payment amounts.",
            "warning"
        );
        $(this).val("");
        return;
    }

    let currentSum = 0;
    $(".split-amount").each(function () {
        currentSum += parseFloat($(this).val()) || 0;
    });

    // HARD BLOCK any typing once total is met
    if (currentSum >= grandTotal) {
        updateSplitPaymentTotal();
        return;
    }

    updateSplitPaymentTotal();
});


$(document).on("click", ".remove-split", function () {
    $(this).closest(".split-payment-row").remove();
    updateSplitPaymentTotal(); // critical
});



// Add new split payment row on button click
$("#addSplitPaymentRow").click(function() {
    addSplitPaymentRow();
});

// Function to add a new split payment row
function addSplitPaymentRow(){
    splitPaymentCounter++;
    const row = $(`
        <div class="split-payment-row mb-2" data-id="${splitPaymentCounter}">
            <div class="row">
                <div class="col-md-4">
                    <select class="form-control split-method" required>
                        <option value="">--Select Payment--</option>
                        ${paymentOptions.map(p => `<option value="${p}">${p}</option>`).join("")}
                    </select>
                </div>
                <div class="col-md-4">
                    <input type="text" class="form-control split-transaction" placeholder="Transaction ID" required>
                </div>
                <div class="col-md-3">
                    <input type="number" class="form-control split-amount" min="0" step="0.01" placeholder="Amount" required>
                </div>
                <div class="col-md-1">
                    <button type="button" class="btn btn-danger remove-split">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
        </div>
    `);
    $("#splitPaymentRows").append(row);
}

// Remove split payment row
$(document).on("click", ".remove-split", function(){
    $(this).closest(".split-payment-row").remove();
    calculateTotals(); // Optional: recalc remaining total
});

// Prevent entering split amounts if no items
$(document).on("input", ".split-amount", function () {
    let grandTotal = parseNumber($("#grandTotal").text());
    let value = parseFloat($(this).val()) || 0;

    if (grandTotal === 0) {
        Swal.fire("No Items Added", "Add products before entering payment amounts.", "warning");
        $(this).val("");
        return;
    }

    if (value > grandTotal) {
        Swal.fire(
            "Invalid Amount",
            "A payment amount cannot be greater than the total cash sale.",
            "error"
        );
        $(this).val(grandTotal.toFixed(2));
        value = grandTotal;
    }

    updateSplitPaymentTotal();
});
$(document).on("change", ".split-method", function () {
    let selectedMethod = $(this).val();
    let currentSelect = $(this);

    if (!selectedMethod) return;

    let duplicateFound = false;

    $(".split-method").not(currentSelect).each(function () {
        if ($(this).val() === selectedMethod) {
            duplicateFound = true;
            return false;
        }
    });

    if (duplicateFound) {
        Swal.fire(
            "Duplicate Payment Method",
            "Each split payment must use a different payment method.",
            "warning"
        );
        currentSelect.val("");
        return;
    }

    // Existing logic (Cash auto transaction ID)
    const row = currentSelect.closest(".split-payment-row");
    const txInput = row.find(".split-transaction");

    if (selectedMethod === "Cash") {
        txInput
            .val(generateCashTransactionId())
            .prop("readonly", true)
            .prop("required", true);
    } else {
        txInput
            .val("")
            .prop("readonly", false)
            .prop("required", true);
    }
});

// Prevent single payment amount (if you have an input) from exceeding total
$("#payment_amount").on("input", function(){
    let grandTotal = parseNumber($("#grandTotal").text());
    let amount = parseFloat($(this).val()) || 0;

    if(grandTotal === 0){
        Swal.fire("No Items Added", "Add products before entering payment amounts.", "warning");
        $(this).val("");
        return;
    }

    if(amount > grandTotal){
        Swal.fire("Invalid Amount", "Amount paid cannot exceed total.", "error");
        $(this).val(grandTotal.toFixed(2));
    }
});


$(document).on("change", ".split-method", function(){
    const row = $(this).closest(".split-payment-row");
    const txInput = row.find(".split-transaction");

    if($(this).val() === "Cash"){
        const cashTxId = generateCashTransactionId();
        txInput.val(cashTxId).prop("readonly", true);
    } else {
        txInput.val("").prop("readonly", false).prop("required", true);
    }
});
// Toggle split payment container
$("#split_payment").change(function(){
    if($(this).is(":checked")) {
        $("#payment_method, #transaction_id_group").hide(); // hide completely
        $("#splitPaymentContainer").slideDown();
        addSplitPaymentRow(); // Add initial row
    } else {
        $("#payment_method, #transaction_id_group").show(); // show back
        $("#splitPaymentContainer").slideUp();
        $("#splitPaymentRows").empty();
    }
});


$(document).on("input", ".split-transaction, #transaction_id", function(){
    const input = $(this);
    const txId = input.val().trim();

    if(txId.length > 2){ // small delay could be added
        $.ajax({
            url: "controllers/sales_controller.php",
            method: "POST",
            data: { action: "check_transaction_id", transaction_id: txId },
            dataType: "json",
            success: function(res){
                if(res.exists){
                    input.addClass("is-invalid");
                    if(!input.next(".invalid-feedback").length){
                        input.after('<div class="invalid-feedback">Transaction ID already exists!</div>');
                    }
                } else {
                    input.removeClass("is-invalid");
                    input.next(".invalid-feedback").remove();
                }
            }
        });
    } else {
        input.removeClass("is-invalid");
        input.next(".invalid-feedback").remove();
    }
});
function validateSplitAmounts(){
    let totalItems = parseFloat($("#grandTotal").text()) || 0;
    let sum = 0;

    $(".split-amount").each(function(){
        sum += parseFloat($(this).val()) || 0;
    });

    if(sum > totalItems){
        Swal.fire("Invalid Amounts", "Total split payments cannot exceed total cash sale.", "error");
        return false;
    }
    return true;
}


    //-----------------Initialize Select2--------------------
    $('.select2').select2();   // ------------------------------------------------------
    // VAT RATE USED FOR CASH SALE
    // ------------------------------------------------------
    const VAT_RATE = <?= $vat_value ?>;


    // ------------------------------------------------------
    // PRODUCT SELECTION — auto-fill stock & price
    // ------------------------------------------------------
    $("#product_select").change(function () {
        let p = $("#product_select option:selected");

        $("#current_stock").val(p.data("stock") ?? "");
        $("#selling_price").val(
            p.data("price") ? parseFloat(p.data("price")).toFixed(2) : ""
        );
    });

    $("#customer_id").change(function () {
        let val = $(this).val();

        if (val === "Walk-In") {
            $("#walkin_fields").slideDown();
            $("#walkin_name, #walkin_phone").prop("required", true);
        } else {
            $("#walkin_fields").slideUp();
            $("#walkin_name, #walkin_phone")
                .val("")
                .prop("required", false);
        }
    });



    // ------------------------------------------------------
    // ADD ITEM TO CASH SALE TABLE
    // ------------------------------------------------------
    $("#addItemBtn").click(function () {

        let productID = $("#product_select").val();
        let category = $("#product_select option:selected").data("category");
        let productName = $("#product_select option:selected").data("name");
        let price = parseFloat($("#selling_price").val());
        let qty = parseInt($("#qty").val());
        let stock = parseInt($("#current_stock").val());


        if (!productID)
            return Swal.fire("Missing Product", "Please select a product.", "warning");

        if (!qty || qty < 1)
            return Swal.fire("Invalid Quantity", "Enter a valid quantity.", "warning");

        if (qty > stock)
            return Swal.fire("Stock Error", "Quantity exceeds available stock!", "error");

        // Prevent duplicate item
        let exists = $("#cashSaleTable tbody tr[data-id='" + productID + "']").length > 0;
        if (exists)
            return Swal.fire("Duplicate Item", "This product is already added.", "info");

        let displayPrice = getDisplayPrice(price);
        let total = displayPrice * qty;


        let row = `
        <tr data-id="${productID}" data-stock="${stock}" data-category="${category}" data-base-price="${price}">

            <td>${productName}</td>

            <td class="text-center">
                <input type="text"
                    class="form-control form-control-sm price-input text-right"
                    value="${displayPrice.toFixed(2)}"

                    readonly
                    style="width:100px;">

            </td>

            <td class="text-center">
                <input type="number" 
                    class="form-control form-control-sm qty-input" 
                    value="${qty}" 
                    min="1"
                    style="width:80px;">
            </td>

            <td class="text-right item-total"><input type="text" class="form-control form-control-sm item-total-input" value="${total.toFixed(2)}" readonly></td>

            <td class="text-center">
                <button class="btn btn-danger btn-sm deleteRow">
                    <i class="fa fa-times"></i>
                </button>
            </td>
        </tr>
        `;


        $("#cashSaleTable tbody").append(row);
        calculateTotals();

        $("#product_select").val("");
        $("#current_stock").val("");
        $("#selling_price").val("");
        $("#qty").val(1);
    });

    function hasBatteryItem() {
        let found = false;
        const batteryCategories = [
            "CAR BATTERIES",
            "SOLAR BATTERIES",
            "CAR BATTERIES - OTHER BRANDS"
        ];

        $("#cashSaleTable tbody tr").each(function () {
            const category = $(this).data("category");
            if (batteryCategories.includes(category)) {
                found = true;
                return false; // break the loop
            }
        });

        return found;
    }
    function refreshItemRowPrices() {
    $("#cashSaleTable tbody tr").each(function () {
        let row = $(this);
        let basePrice = parseFloat(row.data("base-price"));
        let qty = parseInt(row.find(".qty-input").val());

        let displayPrice = getDisplayPrice(basePrice);
        let lineTotal = displayPrice * qty;

        row.find(".price-input").val(displayPrice.toFixed(2));
        row.find(".item-total-input").val(lineTotal.toFixed(2));
    });
}



    function getDisplayPrice(basePrice) {
        if ($("#apply_vat").is(":checked")) {
            return basePrice / (1 + VAT_RATE); // remove VAT
        }
        return basePrice;
    }



    // DELETE ROW
    $(document).on("click", ".deleteRow", function () {
        $(this).closest("tr").remove();
        calculateTotals();
    });





    // UPDATE QTY
    $(document).on("input", ".qty-input", function () {

        let row   = $(this).closest("tr");
        let qty   = parseInt($(this).val());
        let price = parseFloat(row.find(".price-input").val()); // FIX
        let stock = parseInt(row.data("stock"));

        if (isNaN(qty) || qty < 1) {
            Swal.fire("Invalid Quantity", "Minimum quantity is 1.", "warning");
            $(this).val(1);
            qty = 1;
        }

        if (qty > stock) {
            Swal.fire("Stock Limit", "Quantity exceeds available stock!", "error");
            $(this).val(stock);
            qty = stock;
        }

        let newTotal = qty * price;
        row.find(".item-total-input").val(newTotal.toFixed(2));

        calculateTotals();
    });



    // ------------------------------------------------------
    // TOTALS CALCULATION FOR CASH SALE
    // ------------------------------------------------------
    function calculateTotals() {
    let subtotal = 0;
    let vatAmount = 0;

    // Loop through each item row
    $("#cashSaleTable tbody tr").each(function () {
        let row = $(this);
        let basePrice = parseFloat(row.data("base-price")); // VAT-inclusive
        let qty = parseInt(row.find(".qty-input").val());
        let displayPrice = getDisplayPrice(basePrice); // VAT-exclusive if VAT applied

        let lineTotal = displayPrice * qty;

        row.find(".item-total-input").val(lineTotal.toFixed(2));


        subtotal += lineTotal;

        // Calculate VAT for this line
        if ($("#apply_vat").is(":checked")) {
            vatAmount += (basePrice - displayPrice) * qty; // VAT portion per item
        }
    });

    // Apply discount (flat amount)
    let discount = parseFloat($("#discount").val()) || 0;
    subtotal -= discount;

    // Grand total = subtotal + VAT
    let grandTotal = subtotal + vatAmount;

    // Store raw totals
    TOTALS.subTotal = subtotal;
    TOTALS.vatAmount = vatAmount;
    TOTALS.grandTotal = grandTotal;
    TOTALS.discount = discount;

    // Update summary display
    $("#subTotal").text(formatNumberWithCommas(subtotal));
    $("#vatAmount").text(formatNumberWithCommas(vatAmount));
    $("#grandTotal").text(formatNumberWithCommas(grandTotal));
    $("#discountAmount").text(formatNumberWithCommas(discount));

    if ($("#split_payment").is(":checked")) {
        updateSplitPaymentTotal();
    }

}





    $("#discount").on("input", calculateTotals);
    $("#apply_vat").on("change", function () {
        refreshItemRowPrices();
        calculateTotals();
    });



    // ------------------------------------------------------
    // SHOW/HIDE TRANSACTION ID depending on payment method
    // ------------------------------------------------------
    $("#payment_method").change(function () {
        let method = $(this).val();

        if (method === "Cash") {

    let cashTxId = generateCashTransactionId();

    $("#transaction_id_group").show();
    $("#transaction_id")
        .val(cashTxId)
        .prop("readonly", true)
        .prop("required", true);

} else if (method === "") {

    $("#transaction_id_group").hide();
    $("#transaction_id").val("").prop("readonly", false);

} else {

    $("#transaction_id_group").show();
    $("#transaction_id")
        .val("")
        .prop("readonly", false)
        .prop("required", true);
}

    });

    function generateCashTransactionId() {
                const now = new Date();

                const datePart =
                    now.getFullYear().toString() +
                    String(now.getMonth() + 1).padStart(2, '0') +
                    String(now.getDate()).padStart(2, '0');

                const randomPart = Math.random().toString(36).substring(2, 6).toUpperCase();

                return `CASH-${datePart}-${randomPart}`;
            }



    // ------------------------------------------------------
    // SAVE CASH SALE
    // ------------------------------------------------------
    $("#saveCashSaleBtn").click(function () {
        let customer_id      = $("#customer_id").val();
        let discount         = parseFloat($("#discount").val()) || 0;
        let cash_sale_number = $("#cash_sale_number").val();
        let warehouse_id     = $("#warehouse_id").val();
        let debug            = 0;
        let apply_vat = $("#apply_vat").is(":checked") ? 1 : 0;
        let walkin_name  = $("#walkin_name").val();
        let walkin_phone = $("#walkin_phone").val();



        if ($("#cashSaleTable tbody tr").length === 0) {
            return Swal.fire("Empty Cash Sale", "Add at least one product.", "warning");
        }

        if (!$("#customer_id").val()) {
            return Swal.fire("Select Customer", "Please choose a customer.", "warning");
        }

        let cashSaleDate = $("#cash_sale_date").val().trim();
        if (cashSaleDate === "") {
            return Swal.fire("Select Date", "Please choose cash sale date.", "warning");
        }


        let items = [];
        $("#cashSaleTable tbody tr").each(function () {
            let row = $(this);
            items.push({
                product_code: row.data("id"),
                price: parseFloat(row.data("base-price")),
                qty: parseInt(row.find(".qty-input").val())
            });

        });

        let payments = [];
        let totalPaid = 0;
        let grandTotal = TOTALS.grandTotal; // Use the numeric value


        /**
         * CASE 1: SPLIT PAYMENT ENABLED
         */
        if ($("#split_payment").is(":checked")) {

            $(".split-payment-row").each(function () {
                let method = $(this).find(".split-method").val();
                let amount = parseFloat($(this).find(".split-amount").val()) || 0;
                let txid   = $(this).find(".split-transaction").val() || null;

                if (!method) {
                    Swal.fire(
                        "Payment Method Required",
                        "Please select the payment method for all payment entries.",
                        "warning"
                    );
                    payments = [];
                    return false;
                }

                if (method !== "Cash" && (!txid || txid.trim() === "")) {
                    Swal.fire(
                        "Transaction ID Required",
                        "All non-cash payments must have a transaction ID.",
                        "warning"
                    );
                    payments = [];
                    return false;
                }

                if (amount <= 0) {
                    Swal.fire(
                        "Invalid Amount",
                        "Payment amounts must be greater than zero.",
                        "warning"
                    );
                    payments = [];
                    return false;
                }

                totalPaid += amount;

                payments.push({
                    method: method,
                    amount: amount,
                    transaction_id: txid
                });
            });

            if (payments.length === 0) return;

            if (totalPaid !== grandTotal) {
                return Swal.fire(
                    "Payment Mismatch",
                    "Total split payments must equal the total cash sale amount.",
                    "warning"
                );
            }

        /**
         * CASE 2: SINGLE PAYMENT
         */
        } else {

            let method = $("#payment_method").val();
            let txid   = $("#transaction_id").val();
            let amount = grandTotal;

            if (!method) {
                return Swal.fire(
                    "Payment Method Required",
                    "Please select the payment method.",
                    "warning"
                );
            }

            if (method !== "Cash" && (!txid || txid.trim() === "")) {
                return Swal.fire(
                    "Transaction ID Required",
                    "Please enter the transaction ID for this payment.",
                    "warning"
                );
            }

            payments.push({
                method: method,
                amount: amount,
                transaction_id: txid || null
            });
        }


        console.log("Payments:", payments,"Items:", items);

        Swal.fire({
            title: 'Are you sure?',
            text: "Do you want to save this cash sale?",
            icon: 'question',
            showCancelButton: true,
            confirmButtonText: 'Yes, save it!',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {

                $.ajax({
                    url: 'controllers/sales_controller.php',
                    method: 'POST',
                    data: {
                        action: 'save_cash_sale',
                        customer_id: customer_id,
                        discount: discount,
                        walkin_name: walkin_name,
                        walkin_phone: walkin_phone,
                        cash_sale_date: cashSaleDate,
                        cash_sale_number: cash_sale_number,
                        warehouse_id: warehouse_id,
                        apply_vat: apply_vat,

                        payments: payments,

                        scrap_collected: $("#scrap_collected").is(":checked") ? 1 : 0,
                        scrap_quantity: parseInt($("#scrap_quantity").val()) || 0,

                        items: items,
                        debug: debug
                    },



                    dataType: 'json',
                    success: function (response) {

                        if (response.status === 'preview') {
                            Swal.fire({
                                icon: 'info',
                                title: 'Preview Only',
                                html: `<pre style="text-align:left">${JSON.stringify(response, null, 2)}</pre>`,
                                width: 650
                            });
                            return;
                        }

                        if (response.status === 'success') {
                            Swal.fire({
                                icon: 'success',
                                title: 'Cash Sale Saved',
                                text: 'Cash sale has been saved successfully.'
                            }).then(() => {
                                window.location.href = 'cash_sale_receipt.php?id=' + response.cash_sale_id;
                            });

                        } else {
                            Swal.fire("Error", response.message, "error");
                        }
                    },
                    error: function () {
                        Swal.fire("Error", "Something went wrong while saving cash sale.", "error");
                    }
                });

            }
        });

    });
    let scrapDiscount = 0; // flat amount per scrap item

$("#scrap_collected").on("change", function () {
    let checked = $(this).is(":checked");

    if (!checked) {
        // Remove only the scrap discount from total discount
        let currentDiscount = parseFloat($("#discount").val()) || 0;
        let scrapQuantity = parseInt($("#scrap_quantity").val()) || 1;
        $("#discount").val((currentDiscount - scrapDiscount * scrapQuantity).toFixed(2));

        scrapDiscount = 0;
        $("#scrap_quantity_group").hide();
        calculateTotals();
        return;
    }

    // RULE 1: must have items
    if ($("#cashSaleTable tbody tr").length === 0) {
        Swal.fire(
            "Scrap Not Applicable",
            "Add a battery item before applying scrap discount.",
            "warning"
        );
        $(this).prop("checked", false);
        return;
    }

    // RULE 2: must contain BATTERY category
    if (!hasBatteryItem()) {
        Swal.fire(
            "Scrap Discount",
            "Scrap discount applies only to battery items.",
            "warning"
        );
        $(this).prop("checked", false);
        return;
    }

    // Show quantity input
    $("#scrap_quantity_group").show();
    $("#scrap_quantity").val(1); // default quantity

    // Fetch scrap amount (flat / config-based)
    $.ajax({
        url: "controllers/sales_controller.php",
        type: "POST",
        dataType: "json",
        data: {
            action: "get_scrap_amount",
            value: 'scrap_collection_fee'
        },
        success: function (res) {
            if (res.status === "success") {
                scrapDiscount = parseFloat(res.amount);
                updateScrapDiscount();
            } else {
                Swal.fire("Info", res.message, "info");
                scrapDiscount = 0;
                updateScrapDiscount();
            }
        },
        error: function () {
            Swal.fire("Error", "Failed to fetch scrap amount.", "error");
            scrapDiscount = 0;
            updateScrapDiscount();
        }
    });
});

function formatNumberWithCommas(num) {
    if (isNaN(num)) return "0.00";
    return Number(num).toLocaleString(undefined, {
        minimumFractionDigits: 2,
        maximumFractionDigits: 2
    });
}

// Function to parse user input back to raw number
function parseNumber(input) {
    if (typeof input === "string") {
        return parseFloat(input.replace(/,/g, '')) || 0;
    }
    return Number(input) || 0;
}



// Update discount whenever scrap quantity changes
$("#scrap_quantity").on("input", function () {
    updateScrapDiscount();
});

function updateScrapDiscount() {
    let quantity = parseInt($("#scrap_quantity").val()) || 1;
    let currentDiscount = parseFloat($("#discount").val()) || 0;

    // Remove previous scrap discount
    currentDiscount -= scrapDiscount * (quantity - 1); // prevent double-counting
    if (currentDiscount < 0) currentDiscount = 0;

    // Apply new scrap discount
    $("#discount").val((scrapDiscount * quantity).toFixed(2));
    calculateTotals();
}




    </script>
    

    </body>
    </html>
