<?php
    include('menu_supervisor.php');
    include_once 'model/stock_model.php';
    include_once 'model/warehouse_model.php';
    include_once 'model/customers_model.php';
    include_once 'model/common_model.php';
    include_once 'model/sales_model.php';
    include_once 'helpers.php';

    $stock_model = new stock_model();
    $warehouse_model = new warehouse_model();
    $customer_model = new customers_model();
    $common_model = new common_model();
    $sales_model = new sales_model();

    $dn_number      = $_GET['dn_number'] ?? '';
    $invoice_number   = getNextInvoiceNumber($location);

    if (!$dn_number) {
        die("Delivery Note not specified.");
    }

    // Fetch DN details
    $dn = $sales_model->getDeliveryNoteDetails($dn_number);
    $dn_items = $sales_model->getInvoiceItems($dn_number);

    // Fetch customer
    $customer_id = $dn['customer'];
    $customer = $customer_model->getCustomerById($customer_id);

    // Warehouse details
    $warehouseDetails = $warehouse_model->getWarehouseDetails($dn['shop_location'] ?? 1);

    // Company VAT
    $companyDetails = $common_model->getCompanyDetails();
    $vat_value = $companyDetails['vat_percentage'];

?>
<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta charset="utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1">
            <title>Create Invoice from DN</title>

            <link rel="icon" type="image/png" href="../finance/images/favicon.png">

            <style>
                .summary-box h5, .summary-box h3 { margin: 8px 0; }
                </style>
                <style>
                /* Summary font adjustments */
                .summary-box, 
                .summary-box h5, 
                .summary-box h3, 
                #subTotal, 
                #vatAmount, 
                #grandTotal {
                    font-family: "Times New Roman", serif !important;
                }

                /* Sizes + colors */
                .summary-box h5 {
                    font-size: 18px;
                    color: #333;
                }

                .summary-box h3 {
                    font-size: 24px;
                    color: #0a7d12; /* green total */
                }
                /* Make Select2 match Bootstrap form-control styling */
                .select2-container .select2-selection--single {
                    height: 38px !important;
                    padding: 6px 12px;
                    border: 1px solid #ced4da !important;
                    border-radius: 4px !important;
                    background-color: #fff !important;
                }

                .select2-container--default .select2-selection--single .select2-selection__rendered {
                    line-height: 26px !important;
                    color: #495057 !important;
                    font-size: 17   px;
                }

                .select2-container--default .select2-selection--single .select2-selection__arrow {
                    height: 36px !important;
                    right: 8px;
                }

                /* Focus style same as Bootstrap */
                .select2-container--default.select2-container--focus .select2-selection--single {
                    border-color: #80bdff !important;
                    box-shadow: 0 0 0 0.2rem rgba(0,123,255,.25) !important;
                    outline: 0;
                }

                /* Match input height also for multiple select (if you use it later) */
                .select2-container .select2-selection--multiple {
                    min-height: 38px !important;
                    border: 1px solid #ced4da !important;
                    border-radius: 4px !important;
                }
                #invoiceTable td,
                    #invoiceTable th {
                        vertical-align: middle !important;
                    }
            </style>
        </head>
        
        <body class="hold-transition sidebar-mini layout-fixed">
            <div class="content-wrapper p-4">
                <div class="mb-4">
                    <h4 class="text-primary"><i class="fa fa-shopping-cart"></i> New Customer Invoice</h4>
                </div>
                <!-- HEADER INFO -->
                <div class="card shadow-sm mb-4">
                    <div class="card-body row">

                        <div class="col-md-2">
                            <label><strong>Warehouse</strong></label>
                            <input type="text" class="form-control" value="<?= htmlspecialchars($warehouseDetails['warehouse_name']) ?>" readonly>
                            <input type="hidden" id="warehouse_id" name="warehouse_id" value="<?= $location ?>" readonly>
                        </div>
                        
                        <div class="col-md-2">
                            <label><strong>Invoice Number</strong></label>
                            <input type="text" class="form-control" id="invoice_number" name="invoice_number" value="<?= htmlspecialchars($invoice_number) ?>" readonly>
                        </div>

                        <div class="col-md-2">
                            <label><strong>Customer</strong></label>
                            <input type="text" class="form-control" value="<?= $customer['customer_name'] ?>" readonly>
                        </div>

                        <div class="col-md-2">
                            <label><strong>Customer Balance</strong></label>
                            <input type="text" id="customer_balance" class="form-control" value="<?= $customer['balance'] ?>" readonly>
                        </div>

                        <div class="col-md-2">
                            <label><strong>Date</strong></label>
                            <input type="date" class="form-control" id="invoice_date" max="<?= date('Y-m-d') ?>" name="invoice_date" required>
                        </div>

                        <div class="col-md-2">
                            <label><strong>LPO Number</strong></label>
                            <input type="text" class="form-control" id="lpo_number" placeholder="Enter Invoice LPO Number" name="lpo_number" required>
                        </div>

                    </div>
                </div>

                <div class="row">

                    <!-- LEFT: ITEMS TABLE -->
                    <div class="col-md-8">
                        <div class="card shadow-sm mb-4">
                            <div class="card-header bg-dark text-white">
                                <strong>Invoice Items (from DN <?= $dn_number ?>)</strong>
                            </div>

                            <div class="card-body table-responsive">
                                <table class="table table-bordered table-striped" id="invoiceTable">
                                    <thead class="thead-dark">
                                        <tr>
                                            <th>Product</th>
                                            <th>Category</th>
                                            <th width="10%">Qty</th>
                                            <th width="20%">Price</th>
                                            
                                            <th width="20%">Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach($dn_items as $item): ?>
                                        <tr 
                                            data-item_id="<?= $item['id'] ?>" 
                                            data-product_code="<?= $item['product_id'] ?>" 
                                            data-price-inc-vat="<?= $item['p_price'] ?>"
                                        >

                                            <td><?= htmlspecialchars($item['product_name']) ?></td>
                                            <input type="hidden" data-product_id="<?= $item['product_id'] ?>">
                                            <td><?= htmlspecialchars($item['categoryname'] ?? '') ?></td>
                                            <td>
                                                <input type="hidden" data-item_id=<?= $item['id'] ?>  name="item_id" value="<?= $item['id'] ?>">
                                                <input type="number" class="form-control qty-input" value="<?= $item['qty'] ?>" readonly>
                                            </td>
                                            <td><input type="number" class="form-control price-input" value="<?= $item['p_price'] ?>"></td>
                                            <td><input type="text" style="text-align: right;" class="form-control item-total-input" value="<?= number_format($item['p_price']*$item['qty'],2) ?>" readonly></td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="card mb-4 shadow-sm">
                            <div class="card-body">

                                <div class="form-group mb-3">
                                    <label><strong>Discount</strong></label>
                                    <input type="number" class="form-control" id="discount" value="0">
                                </div>

                                <div class="form-group mb-3">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" id="applyVAT" checked>
                                        <label class="custom-control-label" for="applyVAT"><strong>Apply VAT</strong></label>
                                    </div>
                                </div>

                                <div class="p-3 border rounded bg-light summary-box">
                                    <h5>Subtotal <span class="float-right" id="subTotal">0.00</span></h5>
                                    <h5>Discount <span class="float-right" id="discountAmount">0.00</span></h5>
                                    <h5>VAT <span class="float-right" id="vatAmount">0.00</span></h5>
                                    <hr>
                                    <h3>Total <span class="float-right" id="grandTotal">0.00</span></h3>
                                </div>

                                <button class="btn btn-success btn-lg btn-block mt-3" id="saveInvoiceBtn">
                                    <i class="fa fa-check-circle mr-1"></i>Save Invoice
                                </button>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <script src="../includes/plugins/jquery/jquery.min.js"></script>
            <script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
            <script src="../includes/plugins/select2/js/select2.min.js"></script>
            <script>
                const VAT_RATE = <?= $vat_value ?>;

                function formatDisplay(value) {
                    return Number(value).toLocaleString('en-US', { minimumFractionDigits:2, maximumFractionDigits:2 });
                }

                function calculateTotals() {
                    let total = 0;
                    $("#invoiceTable tbody tr").each(function() {
                        let row = $(this);
                        let price = parseFloat(row.find(".price-input").val()) || 0;
                        let qty = parseInt(row.find(".qty-input").val()) || 0;
                        total += price*qty;
                        row.find(".item-total-input").val(formatDisplay(price*qty));
                    });

                    let discount = parseFloat($("#discount").val()) || 0;
                    let applyVAT = $("#applyVAT").is(":checked");
                    let vatAmount = applyVAT ? (total / (1+VAT_RATE))*VAT_RATE : 0;
                    let subtotal = total - vatAmount - discount;
                    let grandTotal = subtotal + vatAmount;

                    $("#subTotal").text(formatDisplay(subtotal));
                    $("#vatAmount").text(formatDisplay(vatAmount));
                    $("#grandTotal").text(formatDisplay(grandTotal));
                    $("#discountAmount").text(formatDisplay(discount));
                }

                // Recalculate totals on price change, VAT toggle, discount change
                $(document).on("input", ".price-input, #discount", calculateTotals);
                $("#applyVAT").change(calculateTotals);

                $(document).ready(calculateTotals);

                // SAVE INVOICE (AJAX)
                $("#saveInvoiceBtn").click(function () {

                    let invoiceDate = $("#invoice_date").val();
                    let lpoNumber   = $("#lpo_number").val();

                    if (!invoiceDate) {
                        Swal.fire({
                            icon: 'warning',
                            title: 'Missing Invoice Date',
                            text: 'Please select the invoice date.',
                            customClass: {
                                confirmButton: 'btn btn-primary px-4'
                            },
                            buttonsStyling: false
                        });
                        return;
                    }

                    if (!lpoNumber) {
                        Swal.fire({
                            icon: 'warning',
                            title: 'Missing LPO Number',
                            text: 'Please enter the LPO number.',
                            customClass: {
                                confirmButton: 'btn btn-primary px-4'
                            },
                            buttonsStyling: false
                        });
                        return;
                    }

                    let items = [];
                    $("#invoiceTable tbody tr").each(function () {
                        let row = $(this);

                        items.push({
                            item_id: row.data("item_id"),
                            product_code: row.data("product_code"),
                            qty: parseInt(row.find(".qty-input").val()) || 0,
                            price: parseFloat(row.find(".price-input").val()) || 0
                        });
                    });

                    Swal.fire({
                        title: 'Create Invoice?',
                        text: 'This will generate the invoice from the selected Delivery Note.',
                        icon: 'question',
                        showCancelButton: true,
                        reverseButtons: true, // Cancel left, Confirm right
                        focusCancel: true,
                        confirmButtonText: 'Create Invoice',
                        cancelButtonText: 'Cancel',
                        customClass: {
                            confirmButton: 'btn btn-success px-4 mx-2',
                            cancelButton: 'btn btn-outline-secondary px-4 mx-2'
                        },
                        buttonsStyling: false
                    }).then((result) => {

                        if (!result.isConfirmed) return;

                        // Disable button to prevent double click
                        $("#saveInvoiceBtn").prop("disabled", true);

                        Swal.fire({
                            title: 'Processing Invoice',
                            html: 'Please wait while we save the invoice...',
                            allowOutsideClick: false,
                            allowEscapeKey: false,
                            didOpen: () => {
                                Swal.showLoading();
                            }
                        });

                        $.ajax({
                            url: "controllers/sales_controller.php",
                            method: "POST",
                            data: {
                                action: 'save_invoice_dn',
                                invoice_number: "<?= $invoice_number ?>",
                                dn_number: "<?= $dn_number ?>",
                                customer_id: <?= $customer_id ?>,
                                invoice_date: invoiceDate,
                                lpo_number: lpoNumber,
                                warehouse_id : <?= $location ?>,
                                vat_applicable: $("#applyVAT").is(":checked"),
                                discount: parseFloat($("#discount").val()) || 0,
                                items: items,
                                debug:0
                            },
                            dataType: "json",
                            success: function (res) {

                                if (res.status === 'success') {


                                    Swal.fire({
                                        icon: 'success',
                                        title: 'Invoice Created Successfully',
                                        text: 'The invoice has been saved.',
                                        confirmButtonText: 'View Invoice',
                                        customClass: {
                                            confirmButton: 'btn btn-success px-4'
                                        },
                                        buttonsStyling: false
                                    }).then(() => {
                                        window.location.href =
                                            'customer_invoice.php?invoice_number=' + res.invoice_id;
                                    });

                                } else {

                                    $("#saveInvoiceBtn").prop("disabled", false);

                                    Swal.fire({
                                        icon: 'error',
                                        title: 'Failed to Save Invoice',
                                        text: res.message || 'Something went wrong.',
                                        customClass: {
                                            confirmButton: 'btn btn-danger px-4'
                                        },
                                        buttonsStyling: false
                                    });
                                }
                            },
                            error: function (xhr) {

                                $("#saveInvoiceBtn").prop("disabled", false);

                                Swal.fire({
                                    icon: 'error',
                                    title: 'Server Error',
                                    text: 'Unable to process request. Please try again.',
                                    customClass: {
                                        confirmButton: 'btn btn-danger px-4'
                                    },
                                    buttonsStyling: false
                                });

                                console.log(xhr.responseText);
                            }
                        });

                    });

                });



            </script>
        </body>
    </html>
