<?php 
    include('menu_supervisor.php');
    include_once 'model/stock_model.php';
    include_once 'model/warehouse_model.php';
    include_once 'model/branch_model.php';    
    include_once 'model/customers_model.php';
    include_once 'model/common_model.php';
    include_once 'helpers.php';

    $stock_model     = new stock_model();
    $warehouse_model = new warehouse_model();
    $branch_model    = new branch_model();
    $customer_model  = new customers_model();
    $common_model    = new common_model();

    $companyDetails = $common_model->getCompanyDetails();
    $vat_value      = $companyDetails['vat_percentage'];

    $quotation_number   = $_GET['quote_number'] ?? getNextQuotationNumber($location);
    $warehouses         = $warehouse_model->getWarehouses();
    $branches           = $branch_model->getBranches(); 
    $customers          = $customer_model->getCustomers($location, [], [1,2]);
    $locked_customer_id = isset($_GET['customer_id']) ? (int)$_GET['customer_id'] : 0;
?>
<!DOCTYPE html>
    <html lang="en">
        <head>
            <meta charset="utf-8">
            <title>Powertex || New Quotation</title>

            <style>
                body { background:#eef1f4 }
                .section-title{font-size:18px;font-weight:600;color:#3c8dbc;border-left:4px solid #3c8dbc;padding-left:10px;margin-bottom:15px}
                .card-modern{background:#fff;border-radius:6px;padding:20px;box-shadow:0 2px 6px rgba(0,0,0,.08);margin-bottom:20px}
                .totals-wrapper{background:#f7f9fc;border-radius:6px;padding:18px;border:1px solid #dfe6ee}
                #quotationTable th{background:#3c8dbc;color:#fff}
                .row-flex{display:flex;gap:20px}
                .left-column{flex:0 0 68%;display:flex;flex-direction:column;gap:20px}
                .right-column{flex:0 0 32%}
                .select2-container .select2-selection--single{height:38px!important;padding:6px 12px;border:1px solid #ced4da!important;border-radius:4px!important}
            </style>
        </head>

        <body>
            <div class="content-wrapper p-3">
                <h3 class="text-primary font-weight-bold mb-3">
                    <i class="fa fa-file-text"></i> Create New Quotation
                </h3>

                <form method="POST" action="controllers/quotations_controller.php">

                    <input type="hidden" name="action" value="save_quotation">
                    <input type="hidden" name="locked_customer_id" value="<?= $locked_customer_id ?>">

                    <!-- CUSTOMER -->
                    <div class="card-modern">
                        <div class="section-title">Customer & Location</div>
                        <div class="row">
                            <div class="col-md-3">
                                <label>Quotation Number</label>
                                <input class="form-control" readonly name="quotation_number" value="<?= $quotation_number ?>">
                            </div>
                           <div class="col-md-3">
                                <label>Date</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fa fa-calendar"></i>
                                        </span>
                                    </div>
                                    <input type="date" id="dateInput" class="form-control" max="<?= date('Y-m-d') ?>">
                                </div>
                            </div>


                            <div class="col-md-3">
                                <label>Customer</label>
                                <select id="customerSelect" name="customer_id" class="select2" style="width:100%">
                                    <option value="">Select Customer</option>
                                    <?php foreach($customers as $c): ?>
                                    <option value="<?= $c['customer_id'] ?>"><?= $c['customer_name'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label>Location</label>
                                <select id="locationSelect" name="location"  class="form-control">
                                    <option value="" disabled selected>Select Location</option>
                                    <optgroup label="Warehouses">
                                        <?php foreach($warehouses as $w): ?>
                                            <option value="warehouse|<?= $w['warehouse_id'] ?>">
                                                <?= $w['warehouse_name'] ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                    <optgroup label="Branches">
                                        <?php foreach($branches as $b): ?>
                                            <option value="branch|<?= $b['branch_id'] ?>">
                                                <?= $b['branch_name'] ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row-flex">
                        <!-- LEFT -->
                        <div class="left-column">
                            <div class="card-modern">
                                <div class="section-title">Add Product</div>
                                <div class="row">
                                    <div class="col-md-5">
                                        <label>Product</label>
                                        <select id="productSelect" class="form-control select2">
                                            <option value="">Select Product</option>
                                        </select>
                                    </div>
                                    <div class="col-md-2">
                                        <label>Qty</label>
                                        <input id="productQty" type="number" class="form-control" value="1" min="1">
                                    </div>
                                    <div class="col-md-2">
                                        <label>Price</label>
                                        <input id="productPrice" type="number" class="form-control" step="0.01">
                                    </div>
                                    <div class="col-md-3">
                                        <label>&nbsp;</label>
                                        <button type="button" id="addProductBtn" class="btn btn-primary btn-block">
                                            <i class="fa fa-plus"></i> Add
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <div class="card-modern">
                                <div class="section-title">Quotation Items</div>
                                <table class="table table-bordered" id="quotationTable">
                                    <thead>
                                        <tr>
                                            <th>Product</th>
                                            <th width="140">Price</th>
                                            <th width="120">Qty</th>
                                            <th width="140">Subtotal</th>
                                            <th width="60"></th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                        
                        <div class="right-column">
                            <div class="totals-wrapper">
                                <div class="form-group">
                                    <input type="checkbox" id="applyVAT" checked> Apply VAT
                                    <input type="hidden" name="vat_applied" id="vatApplied" value="1">

                                </div>
                                <label>Subtotal</label>
                                <input id="subtotal" class="form-control mb-2" readonly>

                                <label>VAT (<?= $vat_value ?>%)</label>
                                <input id="vat" class="form-control mb-2" readonly>

                                <label>Total</label>
                                <input id="total" class="form-control mb-3" readonly>
                                <button class="btn btn-success btn-block">
                                    <i class="fa fa-check"></i> Save Quotation
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <script src="../includes/plugins/jquery/jquery.min.js"></script>
            <script src="../includes/plugins/select2/js/select2.full.min.js"></script>

            <script>
                const vatPercentage = <?= $vat_value ?>;
                let products = {};
                function resetQuotationItems() {
                    products = {};
                    $("#quotationTable tbody").empty();
                    $("#subtotal").val('');
                    $("#vat").val('');
                    $("#total").val('');
                }

                // -------- LOAD PRODUCTS BY LOCATION ----------
                function loadProductsByLocation(value) {
                    if (!value) return;

                    $.ajax({
                        url: 'controllers/quotations_controller.php',
                        type: 'POST',
                        dataType: 'json',
                        data: {
                            action: 'get_products_new',
                            location: value
                        },
                        success: function (data) {
                            let select = $("#productSelect");
                            select.empty().append('<option value="">Select Product</option>');

                            data.forEach(p => {
                                select.append(`
                                    <option value="${p.product_id}" data-price="${p.selling_price}">
                                        ${p.product_name} (${parseFloat(p.selling_price).toFixed(2)})
                                    </option>
                                `);
                            });

                            select.trigger('change.select2');
                        }
                    });
                }
    


                $("#locationSelect").change(function () {
                    resetQuotationItems();       // 🔥 clear items
                    loadProductsByLocation(this.value);
                });

                // -------- HELPERS ----------
                function getNetPrice(gross) {
                    return $("#applyVAT").is(":checked") ? gross / (1 + vatPercentage) : gross;
                }
                function fmt(num) {
                    return Number(num || 0).toLocaleString(undefined, {
                        minimumFractionDigits: 2,
                        maximumFractionDigits: 2
                    });
                }


                function updateTotals() {
                    let gross = 0;
                    for (let id in products) gross += products[id].gross_price * products[id].quantity;

                    let vat = $("#applyVAT").is(":checked") ? (gross / (1 + vatPercentage)) * vatPercentage : 0;
                $("#subtotal").val(fmt(gross - vat));
                    $("#vat").val(fmt(vat));
                    $("#total").val(fmt(gross));

                }

                // -------- RENDER ----------
                function renderTable() {
                    let tbody = $("#quotationTable tbody");
                    tbody.empty();

                    for (let id in products) {
                        let p = products[id];
                        let net = getNetPrice(p.gross_price);

                        tbody.append(`
                            <tr>
                                <td>${p.name}</td>
                                <td><input type="number" readonly class="form-control price" data-id="${id}" value="${net.toFixed(2)}"></td>
                                <td><input type="number" class="form-control qty" data-id="${id}" value="${p.quantity}"></td>
                                <td><input class="form-control" readonly value="${fmt(net * p.quantity)}"></td>
                                <td>
                                    <button type="button" class="btn btn-danger btn-sm remove" data-id="${id}">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </td>

                                <input type="hidden" name="products[${id}][price]" value="${p.gross_price}">
                                <input type="hidden" name="products[${id}][quantity]" value="${p.quantity}">
                            </tr>
                        `);
                    }
                    updateTotals();
                }

                // -------- EVENTS ----------
                $("#productSelect").change(function(){
                    $("#productPrice").val($(this).find(":selected").data("price") || '');
                });

                $("#addProductBtn").click(function(){
                    let id = $("#productSelect").val();
                    if (!id) return toastr.error("Select product");

                    if (products[id]) return toastr.warning("Product already added");

                    products[id] = {
                        name: $("#productSelect option:selected").text(),
                        gross_price: parseFloat($("#productPrice").val()),
                        quantity: parseInt($("#productQty").val())
                    };
                    renderTable();
                });

                $(document).on("input", ".price", function(){
                    let id = $(this).data("id");
                    let net = parseFloat($(this).val());
                    products[id].gross_price = $("#applyVAT").is(":checked") ? net * (1 + vatPercentage) : net;
                    renderTable();
                });

                $(document).on("input", ".qty", function(){
                    products[$(this).data("id")].quantity = parseInt($(this).val());
                    renderTable();
                });

                $(document).on("click", ".remove", function(){
                    delete products[$(this).data("id")];
                    renderTable();
                });
        
                $("#applyVAT").change(function () {
                    $("#vatApplied").val(this.checked ? 1 : 0);
                    renderTable();
                });


                <?php if ($locked_customer_id): ?>
                    $("#customerSelect").val(<?= $locked_customer_id ?>).prop("disabled", true);
                <?php endif; ?>

                $('.select2').select2();
            </script>
            <script>
                $("form").on("submit", function (e) {
                    e.preventDefault(); // stop default submit first

                    // 1️⃣ Validate Date
                    if (!$("#dateInput").val()) {
                        Swal.fire({
                            icon: "warning",
                            title: "Date not selected",
                            text: "Please select a date before saving the quotation."
                        });
                        return;
                    }

                    // 2️⃣ Validate Customer
                    if (!$("#customerSelect").val()) {
                        Swal.fire({
                            icon: "warning",
                            title: "Customer not selected",
                            text: "Please select a customer before saving the quotation."
                        });
                        return;
                    }

                    // 3️⃣ Validate Items
                    if (Object.keys(products).length === 0) {
                        Swal.fire({
                            icon: "warning",
                            title: "No items added",
                            text: "Please add at least one product to the quotation."
                        });
                        return;
                    }

                    // 4️⃣ Confirmation
                    Swal.fire({
                        title: "Are you sure?",
                        text: "Do you want to save this quotation?",
                        icon: "question",
                        reverseButtons: true,
                        showCancelButton: true,
                        confirmButtonText: "Save Quotation",
                        cancelButtonText: "Cancel",
                        confirmButtonColor: "#28a745",
                        cancelButtonColor: "#d33"
                    }).then((result) => {
                        if (result.isConfirmed) {
                            e.target.submit(); // ✅ finally submit
                        }
                    });
                });
            </script>
        </body>
    </html>
