<?php
    include_once '../model/common_model.php';
    include_once '../model/sales_model.php';

    $common_model = new common_model();
    $sales_model = new sales_model();

    // $document_number must be passed from your Dompdf generator script
    $document = $sales_model->getDeliveryNoteDetails($document_number ?? '');
    $items = $sales_model->getInvoiceItems($document_number ?? '');
    $company_data = $common_model->getCompanyDetails();

    $document_title = 'Delivery Note';
    include_once 'includes/style.php';
    include_once 'includes/header.php';
?>
<!DOCTYPE html>
    <html>
        <head>
            



        </head>
        <body>
            <?php
                
                
            ?>

            
                

                <table>
                    <thead>
                        <tr>
                            <th width="50%">DESCRIPTION</th>
                            <th width="20%" class="center">CATEGORY</th>
                            <th width="10%">QTY</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php
                            $itemCount = count($items);
                            $minRows   = 6;
                        ?>

                        <!-- ================= ITEMS ================= -->
                        <?php foreach ($items as $item): ?>
                            <tr>
                                <td><?= htmlspecialchars($item['product_name']) ?></td>
                                <td class="center"><?= htmlspecialchars($item['categoryname']) ?></td>
                                <td class="center"><?= (float)$item['qty'] ?></td>
                            </tr>
                        <?php endforeach; ?>

                        <!-- ================= EMPTY ROWS (if < 6 items) ================= -->
                        <?php
                            if ($itemCount < $minRows) {
                                for ($i = $itemCount; $i < $minRows; $i++) {
                                    echo '
                                    <tr>
                                        <td>&nbsp;</td>
                                        <td>&nbsp;</td>
                                        <td>&nbsp;</td>
                                        <td>&nbsp;</td>
                                    </tr>';
                                }
                            }
                        ?>

                        <!-- ================= SUMMARY ================= -->

                


                    </tbody>
                </table>
            </div>
        </body>
    </html>
