<?php
    include_once '../model/common_model.php';
    include_once '../model/sales_model.php';

    $common_model = new common_model();
    $sales_model = new sales_model();

    // $document_number must be passed from your Dompdf generator script
    $document = $sales_model->getInvoiceData($document_number ?? '');
    $items = $sales_model->getReceiptItems($document_number ?? '');
    $company_data = $common_model->getCompanyDetails();

    $document_title = 'Customer Invoice';
    include_once 'includes/style.php';
    include_once 'includes/header.php';
?>
<!DOCTYPE html>
    <html>
        <head>
            



        </head>
        <body>
            <?php
                
                
            ?>

            
                

                <table>
                    <thead>
                        <tr>
                            <th width="50%">DESCRIPTION</th>
                            <th width="10%">QTY</th>
                            <th width="20%">@</th>
                            <th width="20%">TOTAL</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php
                            $itemCount = count($items);
                            $minRows   = 6;
                        ?>

                        <!-- ================= ITEMS ================= -->
                        <?php foreach ($items as $item): ?>
                            <tr>
                                <td><?= htmlspecialchars($item['description']) ?></td>
                                <td class="center"><?= (float)$item['quantity'] ?></td>
                                <td class="right"><?= number_format($item['selling_price'], 2) ?></td>
                                <td class="right"><?= number_format($item['subtotal'], 2) ?></td>
                            </tr>
                        <?php endforeach; ?>

                        <!-- ================= EMPTY ROWS (if < 6 items) ================= -->
                        <?php
                            if ($itemCount < $minRows) {
                                for ($i = $itemCount; $i < $minRows; $i++) {
                                    echo '
                                    <tr>
                                        <td>&nbsp;</td>
                                        <td>&nbsp;</td>
                                        <td>&nbsp;</td>
                                        <td>&nbsp;</td>
                                    </tr>';
                                }
                            }
                        ?>

                        <!-- ================= SUMMARY ================= -->

                        <tr>
                            <td colspan="3" class="right bold">Subtotal</td>
                            <td class="right"><?= number_format($document['subtotal'], 2) ?></td>
                        </tr>

                        <tr>
                            <td colspan="3" class="right bold">
                                VAT <?= (float)$document['vat_percentage'] * 100 ?>%
                            </td>
                            <td class="right"><?= number_format($document['total_tax'], 2) ?></td>
                        </tr>

                        <tr>
                            <td colspan="3" class="right bold">Total</td>
                            <td class="right bold"><?= number_format($document['total_bill'], 2) ?></td>
                        </tr>


                    </tbody>
                </table>
            </div>
        </body>
    </html>
