<?php
include('menu_supervisor.php');
include_once 'model/reports_model.php';

$reports_model = new reports_model();

$from_date = $_GET['from_date'] ?? date('Y-m-01');
$to_date   = $_GET['to_date'] ?? date('Y-m-t');

$overviewData       = $reports_model->getSalesSummary($location, $from_date, $to_date);
$sales_by_category  = $reports_model->getSalesByCategoryGross($location, $from_date, $to_date);

$days = (strtotime($to_date) - strtotime($from_date)) / 86400;

if ($days <= 31) {
    $period = 'daily';
} elseif ($days <= 180) {
    $period = 'weekly';
} else {
    $period = 'monthly';
}


$salesTrendData = $reports_model->getSalesTrend($location, $from_date, $to_date, $period);
$topProducts = $reports_model->getTopProducts($location, $from_date, $to_date);

$productLabels = array_column($topProducts, 'product_name');
$productQty    = array_column($topProducts, 'total_qty');
$productSales  = array_column($topProducts, 'total_sales'); // optional for dual-axis


$trend_labels = [];
$trend_values = [];

foreach ($salesTrendData as $row) {
    $trend_labels[] = $row['label'];
    $trend_values[] = (float)$row['total_sales'];
}

$topCustomers = $reports_model->getSalesByCustomer($location, $from_date, $to_date);

$paymentModes = $reports_model->getPaymentModesSummary($location, $from_date, $to_date);

$paymentLabels = array_column($paymentModes, 'payment_method');
$paymentValues = array_column($paymentModes, 'total_amount');

$salesVsStock = $reports_model->getSalesVsStock($location, $from_date, $to_date);
$discountSummary = $reports_model->getDiscountSummary($location, $from_date, $to_date);
$outstanding = $reports_model->getOutstandingInvoicesSummary($location, $from_date, $to_date);



?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Powertex || Sales Performance Dashboard</title>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
<div class="content-wrapper p-4">

    <div class="d-flex align-items-center justify-content-between mb-4">

    <!-- LEFT: TITLE -->
    <h3 class="mb-0">
        <i class="fas fa-chart-line text-primary mr-1"></i>
        Sales Performance Dashboard
    </h3>

    <!-- RIGHT: FILTERS + ACTIONS -->
    <div class="d-flex align-items-center">

        <!-- FILTER FORM -->
        <form method="GET" class="form-inline mr-2">

            <!-- FROM DATE -->
            <div class="input-group mr-2" style="min-width: 170px;">
                <div class="input-group-prepend">
                    <span class="input-group-text">
                        <i class="fas fa-calendar-alt"></i>
                    </span>
                </div>
                <input type="date"
                       id="from_date"
                       name="from_date"
                       class="form-control"
                       value="<?= htmlspecialchars($from_date) ?>">
            </div>

            <!-- TO DATE -->
            <div class="input-group mr-2" style="min-width: 170px;">
                <div class="input-group-prepend">
                    <span class="input-group-text">
                        <i class="fas fa-calendar-check"></i>
                    </span>
                </div>
                <input type="date"
                       max="<?= date('Y-m-d') ?>"
                       id="to_date"
                       name="to_date"
                       class="form-control"
                       value="<?= htmlspecialchars($to_date) ?>">
            </div>

            <!-- GENERATE -->
            <button class="btn btn-primary mr-2">
                <i class="fas fa-sync-alt mr-1"></i> Process
            </button>
        </form>

        

    </div>
</div>



    <!-- KPI SUMMARY -->
    <div class="row">

        <!-- SALES / REVENUE -->
        <div class="col-lg-2 col-6">
            <div class="small-box bg-info">
                <div class="inner">
                    <h4><?= number_format($overviewData['total_sales'], 2) ?></h4>
                    <p>Gross Sales</p>
                </div>
            </div>
        </div>

        <!-- PAYMENTS RECEIVED -->
        <div class="col-lg-2 col-6">
            <div class="small-box bg-success">
                <div class="inner">
                    <h4><?= number_format($overviewData['total_payments'], 2) ?></h4>
                    <p>Total Payments</p>
                </div>
            </div>
        </div>

        <!-- AVERAGE TRANSACTION -->
        <div class="col-lg-2 col-6">
            <div class="small-box bg-success">
                <div class="inner">
                    <h4>
                        <?= number_format($overviewData['total_cash_sales'],2) ?>
                    </h4>
                    <p>Cash Sale Payments</p>
                </div>
            </div>
        </div>

        <!-- TRANSACTIONS -->
        <div class="col-lg-2 col-6">
            <div class="small-box bg-success">
                <div class="inner">
                    <h4><?= number_format($overviewData['total_invoice_payments'],2) ?></h4>
                    <p>Total Invoice Payments</p>
                </div>
            </div>
        </div>

        <!-- STOCK TURNOVER (TO BE CALCULATED PROPERLY NEXT) -->
        <div class="col-lg-2 col-6">
            <div class="small-box bg-secondary">
                <div class="inner">
                    <h4>—</h4>
                    <p>Stock Turnover Ratio</p>
                </div>
            </div>
        </div>

        <!-- LOW STOCK ITEMS -->
        <div class="col-lg-2 col-6">
            <div class="small-box bg-dark">
                <div class="inner">
                    <h4>
                        <?= array_reduce($salesVsStock, function ($carry, $item) {
                            return $carry + (($item['stock_balance'] <= $item['min_level']) ? 1 : 0);
                        }, 0); ?>
                    </h4>
                    <p>Low Stock Items</p>
                </div>
            </div>
        </div>

    </div>
    

    <div class="row mt-3">
        <div class="col-lg-3 col-6">
            <div class="small-box bg-warning">
                <div class="inner">
                    <h4><?= number_format($discountSummary['cash_discounts'],2) ?></h4>
                    <p>Cash Sale Discounts</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-6">
            <div class="small-box bg-warning">
                <div class="inner">
                    <h4><?= number_format($discountSummary['invoice_discounts'],2) ?></h4>
                    <p>Invoice Discounts</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-6">
            <div class="small-box bg-danger">
                <div class="inner">
                    <h4><?= number_format($discountSummary['total_discounts'],2) ?></h4>
                    <p>Total Discounts Given</p>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-6">
            <div class="small-box bg-danger">
                <div class="inner">
                    <h4><?= $outstanding['invoice_count'] ?> - <?= number_format($outstanding['total_outstanding'],2) ?></h4>
                    <p>Outstanding Invoices</p>
                </div>
            </div>
        </div>
    </div>
    <?php $aging = $reports_model->getInvoiceAging($location); ?>

<div class="row mt-3">
    <div class="col-lg-3 col-6">
        <div class="small-box bg-success">
            <div class="inner">
                <h5><?= number_format($aging['amt_0_30'],2) ?></h5>
                <p>0–30 Days (<?= $aging['cnt_0_30'] ?>)</p>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-6">
        <div class="small-box bg-warning">
            <div class="inner">
                <h5><?= number_format($aging['amt_31_60'],2) ?></h5>
                <p>31–60 Days (<?= $aging['cnt_31_60'] ?>)</p>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-6">
        <div class="small-box bg-orange">
            <div class="inner">
                <h5><?= number_format($aging['amt_61_90'],2) ?></h5>
                <p>61–90 Days (<?= $aging['cnt_61_90'] ?>)</p>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-6">
        <div class="small-box bg-danger">
            <div class="inner">
                <h5><?= number_format($aging['amt_90_plus'],2) ?></h5>
                <p>90+ Days (<?= $aging['cnt_90_plus'] ?>)</p>
            </div>
        </div>
    </div>
</div>



    <!-- SALES TREND -->
    <div class="card mb-4">
    <div class="card-header bg-primary text-white d-flex justify-content-between">
        <strong>Sales Trend (<?= ucfirst($period) ?>)</strong>
        <small>Bars = Volume | Line = Trend</small>
    </div>

    <div class="card-body">
        <canvas id="salesTrendCombo" height="500"></canvas>
    </div>
</div>



    <!-- TOP PRODUCTS + PAYMENT MODES -->
    <div class="row">

        <div class="col-md-6">
            <div class="card mb-4">
                <div class="card-header bg-secondary text-white"><strong>Top 10 Products Sold</strong></div>
                <div class="card-body">
                    <canvas id="topProductsChart" height="400"></canvas>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card mb-4">
                <div class="card-header bg-success text-white"><strong>Payment Modes</strong></div>
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Payment Method</th>
                                <th class="text-right">Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $grandTotal = 0;
                            foreach($paymentModes as $row):
                                $grandTotal += $row['total_amount'];
                            ?>
                                <tr>
                                    <td><?= htmlspecialchars($row['payment_method']) ?></td>
                                    <td class="text-right"><?= number_format($row['total_amount'], 2) ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                        <tfoot>
                            <tr style="font-weight:bold; background:#f1f1f1;">
                                <td class="text-right">TOTAL</td>
                                <td class="text-right"><?= number_format($grandTotal, 2) ?></td>
                            </tr>
                        </tfoot>
                    </table>

            </div>
        </div>

    </div>

    <div class="row">

    <!-- SALES BY CATEGORY -->
    <div class="col-md-4">
        <div class="card mb-4 h-100">
            <div class="card-header bg-info text-white">
                <strong>Sales by Category</strong>
            </div>
            <div class="card-body table-responsive">
                <table class="table table-bordered table-striped mb-0">
                    <thead>
                        <tr>
                            <th>Category</th>
                            <th class="text-center">Qty Sold</th>
                            <th class="text-right">Revenue</th>
                            <th class="text-right">Tax</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($sales_by_category as $row): ?>
                            <tr>
                                <td><?= htmlspecialchars($row['categoryname']) ?></td>
                                <td class="text-center"><?= $row['qty_sold'] ?></td>
                                <td class="text-right"><?= number_format($row['total_sales'], 2) ?></td>
                                <td class="text-right"><?= number_format($row['total_tax'], 2) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- SALES BY PRODUCT -->
    <div class="col-md-4">
        <div class="card mb-4 h-100">
            <div class="card-header bg-dark text-white">
                <strong>Sales by Product</strong>
            </div>
            <div class="card-body table-responsive">
                <table class="table table-striped table-bordered mb-0">
                    <thead>
                        <tr>
                            <th>Product</th>
                            <th class="text-center">Qty Sold</th>
                            <th class="text-right">Revenue</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($topProducts as $p): ?>
                            <tr>
                                <td><?= htmlspecialchars($p['product_name']) ?></td>
                                <td class="text-center"><?= $p['total_qty'] ?></td>
                                <td class="text-right"><?= number_format($p['total_sales'], 2) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card mb-4 h-100">
            <div class="card-header bg-warning"><strong>Sales by Customer</strong></div>
                <div class="card-body table-responsive">
                    <table class="table table-bordered">
                        <thead><tr><th>Customer</th><th>Total Revenue</th></tr></thead>
                        <tbody>
                        <?php foreach($topCustomers as $c): ?>
                            <tr>
                                <td><?= $c['customer_name'] ?></td>
                                <td style="text-align: right;"><?= number_format($c['total_sales'],2) ?></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>


    <!-- STOCK IMPACT -->
    <div class="card mb-4">
    <div class="card-header bg-danger text-white">
        <strong>Stock Impact – Sales vs Stock</strong>
    </div>

    <div class="card-body table-responsive">
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>Product</th>
                    <th class="text-center">Qty Sold</th>
                    <th class="text-center">Stock Balance</th>
                    <th class="text-center">Risk</th>
                </tr>
            </thead>
            <tbody>
            <?php foreach ($salesVsStock as $row): 

                $risk = 'OK';

                if ($row['stock_balance'] <= 0) {
                    $risk = 'Out';
                } elseif ($row['stock_balance'] <= $row['min_level']) {
                    $risk = 'Low';
                }
                ?>

                <tr>
                    <td><?= htmlspecialchars($row['product_name']) ?></td>
                    <td class="text-center"><?= $row['qty_sold'] ?></td>
                    <td class="text-center"><?= $row['stock_balance'] ?></td>
                    <td class="text-center">
                        <?php if ($risk === 'Out'): ?>
                            <span class="badge badge-danger">Out of Stock</span>
                        <?php elseif ($risk === 'Low'): ?>
                            <span class="badge badge-warning">Low Stock</span>
                        <?php else: ?>
                            <span class="badge badge-success">OK</span>
                        <?php endif; ?>
                    </td>

                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>


</div>

<script src="../includes/plugins/jquery/jquery.min.js"></script>
    <script src="../includes/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="../includes/dist/js/adminlte.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function () {

    var ctx = document.getElementById('salesTrendCombo').getContext('2d');

    var trendLabels = <?= json_encode($trend_labels) ?>;
    var trendData   = <?= json_encode($trend_values) ?>;

    new Chart(ctx, {
        type: 'bar', // base type
        data: {
            labels: trendLabels,
            datasets: [
                {
                    label: 'Sales Volume',
                    type: 'bar',
                    data: trendData,
                    backgroundColor: 'rgba(40, 167, 69, 0.6)',
                    borderWidth: 1
                },
                {
                    label: 'Sales Trend',
                    type: 'line',
                    data: trendData,
                    borderColor: '#007bff',
                    backgroundColor: 'transparent',
                    borderWidth: 2,
                    fill: false,
                    lineTension: 0.35,
                    pointRadius: 3
                }
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            legend: {
                position: 'bottom'
            },
            tooltips: {
                callbacks: {
                    label: function(tooltipItem, data) {
                        var label = data.datasets[tooltipItem.datasetIndex].label || '';
                        return label + ': ' + tooltipItem.yLabel.toLocaleString();
                    }
                }
            },
            scales: {
                xAxes: [{
                    gridLines: { display: false }
                }],
                yAxes: [{
                    ticks: {
                        beginAtZero: true,
                        callback: function(value) {
                            return value.toLocaleString();
                        }
                    }
                }]
            }
        }
    });

});

document.addEventListener('DOMContentLoaded', function () {
    var ctx = document.getElementById('topProductsChart').getContext('2d');

    var productLabels = <?= json_encode($productLabels) ?>;
    var productQty    = <?= json_encode($productQty) ?>;
    var productRevenue = <?= json_encode($productSales) ?>;

    // Compute totals
    var totalQty = productQty.reduce((a, b) => a + b, 0);
    var totalRevenue = productRevenue.reduce((a, b) => a + b, 0);

    new Chart(ctx, {
        type: 'bar',
        data: {
            labels: productLabels,
            datasets: [
                {
                    label: 'Quantity Sold',
                    type: 'bar',
                    data: productQty,
                    backgroundColor: 'rgba(69, 117, 180, 0.6)',
                    borderWidth: 1,
                    yAxisID: 'y-axis-qty'
                },
                {
                    label: 'Total Revenue',
                    type: 'line',
                    data: productRevenue,
                    borderColor: '#ff5733',
                    backgroundColor: 'transparent',
                    borderWidth: 2,
                    fill: false,
                    lineTension: 0.35,
                    pointRadius: 3,
                    yAxisID: 'y-axis-revenue'
                }
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            legend: {
                position: 'bottom',
                labels: {
                    generateLabels: function(chart) {
                        return chart.data.datasets.map(function(dataset, i) {
                            var value = dataset.data.reduce((a, b) => a + Number(b), 0); // <-- convert to Number
                            var color = dataset.backgroundColor || dataset.borderColor;
                            return {
                                text: dataset.label + ' (Total: ' + value.toLocaleString() + ')',
                                fillStyle: color,
                                strokeStyle: color,
                                lineWidth: 1,
                                hidden: !chart.isDatasetVisible(i),
                                index: i
                            };
                        });
                    }
                }

            },
            tooltips: {
                callbacks: {
                    label: function(tooltipItem, data) {
                        var datasetLabel = data.datasets[tooltipItem.datasetIndex].label || '';
                        var value = tooltipItem.yLabel;
                        return datasetLabel + ': ' + value.toLocaleString();
                    }
                }
            },
            scales: {
                xAxes: [{
                    gridLines: { display: false }
                }],
                yAxes: [
                    {
                        id: 'y-axis-qty',
                        position: 'left',
                        ticks: {
                            beginAtZero: true,
                            callback: function(value) { return value.toLocaleString(); }
                        },
                        scaleLabel: {
                            display: true,
                            labelString: 'Quantity Sold'
                        }
                    },
                    {
                        id: 'y-axis-revenue',
                        position: 'right',
                        ticks: {
                            beginAtZero: true,
                            callback: function(value) { return value.toLocaleString(); }
                        },
                        scaleLabel: {
                            display: true,
                            labelString: 'Revenue (Net)'
                        },
                        gridLines: { drawOnChartArea: false }
                    }
                ]
            }
        }
    });
});

const paymentColorMap = {
    'Mpamba': '#28a745',
    'Airtel Money': '#dc3545',
    'Visa': '#007bff',
    'Cheque': '#fd7e14',
    'Online Transfer': '#6f42c1',
    'Cash': '#57626dff'
};

const paymentLabels = <?= json_encode($paymentLabels) ?>;
const paymentValues = <?= json_encode($paymentValues) ?>;

const paymentColors = paymentLabels.map(label => paymentColorMap[label] || '#6c757d');

/* Payment Modes */
new Chart(document.getElementById('paymentMethodChart'), {
    type: 'pie',
    data: {
        labels: paymentLabels,
        datasets: [{
            data: paymentValues,
            backgroundColor: paymentColors
        }]
    },
    options: {
        responsive: true,
        legend: { position: 'bottom' },
        tooltips: {
            callbacks: {
                label: function(tooltipItem, data) {
                    const label = data.labels[tooltipItem.index];
                    const value = data.datasets[0].data[tooltipItem.index];
                    return label + ': ' + value.toLocaleString();
                }
            }
        }
    }
});

</script>
<script>
document.addEventListener('DOMContentLoaded', function () {

    const fromDate = document.getElementById('from_date');
    const toDate   = document.getElementById('to_date');

    // Set initial minimum TO date
    if (fromDate.value) {
        toDate.min = fromDate.value;
    }

    // When FROM date changes
    fromDate.addEventListener('change', function () {
        toDate.min = this.value;

        // Auto-correct TO date if invalid
        if (toDate.value && toDate.value < this.value) {
            toDate.value = this.value;
        }
    });

});
</script>


</body>
</html>
